/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class ProcessingContainerBlockEntity
extends BasicLootBlockEntity
implements IProcessingBlock {
    protected static final int[] NO_SLOTS = new int[0];
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe> inputRecipeCache;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe>[] processRecipeCache;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe> outputRecipeCache;
    protected int totalProcessingTime;
    protected int processingTime;
    protected int energy;

    public ProcessingContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, containerSize);
        this.inputRecipeCache = RecipeManager.createCheck(recipeType);
        this.processRecipeCache = this.createCacheArray(this.getInputSlots().length, () -> RecipeManager.createCheck((RecipeType)recipeType));
        this.outputRecipeCache = RecipeManager.createCheck(recipeType);
    }

    protected abstract int[] getInputSlots();

    protected abstract int[] getOutputSlots();

    protected abstract int[] getEnergySlots();

    protected boolean shouldProcessAll() {
        return false;
    }

    protected int getEnergyFor(ItemStack stack) {
        return 0;
    }

    protected void onConsumeEnergy(ItemStack stack) {
    }

    protected boolean handleProcessed(ItemStack stack) {
        return false;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void addEnergy(int energy) {
        this.energy += energy;
        this.setChanged();
    }

    @Override
    public boolean requiresEnergy() {
        return this.getEnergySlots().length > 0;
    }

    @Override
    public int retrieveEnergy(boolean consume) {
        int[] slots;
        for (int slot : slots = this.getEnergySlots()) {
            int energy;
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || (energy = this.getEnergyFor(stack)) <= 0) continue;
            if (consume) {
                this.onConsumeEnergy(stack);
                stack.shrink(1);
                this.setChanged();
            }
            return energy;
        }
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        int time = 0;
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            Optional<? extends ProcessingRecipe> optional;
            int slot = slots[i];
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty() || !(optional = this.getRecipe(this.processRecipeCache[i], stack)).isPresent()) continue;
            time = Math.max(time, optional.get().getTime());
            if (!this.shouldProcessAll()) break;
        }
        if (this.totalProcessingTime != time) {
            this.totalProcessingTime = time;
            this.setChanged();
        }
        return this.totalProcessingTime;
    }

    @Override
    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        if (time != this.processingTime) {
            this.setChanged();
        }
        this.processingTime = time;
    }

    @Override
    public boolean canProcess() {
        return this.canProcessInput();
    }

    protected final boolean canProcessInput() {
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty()) continue;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.processRecipeCache[i], stack);
            if (optional.isEmpty()) {
                return false;
            }
            ItemStack result = optional.get().assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)this.level.registryAccess());
            if (!this.canOutput(stack, result)) {
                return false;
            }
            if (this.shouldProcessAll()) continue;
            return true;
        }
        return !this.isInputEmpty();
    }

    @Override
    public void onCompleteProcess() {
        int[] slots = this.getInputSlots();
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty()) continue;
            ItemStack remainingStack = stack.getItem().getCraftingRemainder();
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(this.processRecipeCache[i], stack);
            ItemStack result = optional.map(recipe -> recipe.assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)this.level.registryAccess())).orElse(ItemStack.EMPTY);
            stack.shrink(1);
            if (!result.isEmpty()) {
                ItemStack copy = result.copy();
                if (!this.handleProcessed(copy)) {
                    this.pushOutput(copy);
                    this.setChanged();
                }
                if (!remainingStack.isEmpty()) {
                    this.setItem(slot, remainingStack.copy());
                }
            }
            if (this.shouldProcessAll()) continue;
            return;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ProcessingContainerBlockEntity processor) {
        processor.processTick();
    }

    protected boolean canOutput(ItemStack input, ItemStack result) {
        int[] slots;
        if (result.isEmpty()) {
            return false;
        }
        int count = 0;
        for (int slot : slots = this.getOutputSlots()) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty()) {
                return true;
            }
            if (this.isOutputInput(slot) && stack.getItem().getCraftingRemainder().isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)stack)) continue;
            count += stack.getMaxStackSize() - stack.getCount();
        }
        return count >= result.getCount();
    }

    protected boolean isOutputInput(int outputSlotIndex) {
        return this.getMaxStackSize() == 1 && this.slotsContains(this.getInputSlots(), outputSlotIndex);
    }

    protected void pushOutput(ItemStack result) {
        int[] slots;
        for (int slot : slots = this.getOutputSlots()) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty()) {
                this.setItem(slot, result);
                return;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
            int count = Math.min(result.getCount(), stack.getMaxStackSize() - stack.getCount());
            stack.grow(count);
            result.shrink(count);
            if (!result.isEmpty()) continue;
            return;
        }
    }

    protected boolean isInputEmpty() {
        int[] slots;
        for (int slot : slots = this.getInputSlots()) {
            ItemStack stack = this.getItem(slot);
            if (stack.isEmpty()) continue;
            return false;
        }
        return slots.length > 0;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe> cache, ItemStack stack) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return cache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), serverLevel).map(RecipeHolder::value);
        }
        return Optional.empty();
    }

    public boolean isRecipe(ItemStack stack, ServerLevel level) {
        return this.inputRecipeCache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    @Override
    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        if (this.slotsContains(this.getInputSlots(), slotIndex)) {
            return this.isSlotInsertable(slotIndex);
        }
        if (this.slotsContains(this.getEnergySlots(), slotIndex)) {
            return this.getEnergyFor(stack) > 0 && this.isSlotInsertable(slotIndex);
        }
        return false;
    }

    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        if (this.slotsContains(this.getOutputSlots(), slotIndex)) {
            if (this.isOutputInput(slotIndex)) {
                return this.getRecipe(this.outputRecipeCache, stack).isEmpty();
            }
            return true;
        }
        return false;
    }

    protected boolean slotsContains(int[] slots, int slotIndex) {
        for (int slot : slots) {
            if (slot != slotIndex) continue;
            return true;
        }
        return false;
    }

    protected RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe>[] createCacheArray(int size, Supplier<RecipeManager.CachedCheck<SingleRecipeInput, ? extends ProcessingRecipe>> fill) {
        RecipeManager.CachedCheck[] array = new RecipeManager.CachedCheck[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = fill.get();
        }
        return array;
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.getInt("MaxProcessTime").ifPresent(value -> {
            this.totalProcessingTime = value;
        });
        input.getInt("ProcessTime").ifPresent(value -> {
            this.processingTime = value;
        });
        input.getInt("Energy").ifPresent(value -> {
            this.energy = value;
        });
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("MaxProcessTime", this.totalProcessingTime);
        output.putInt("ProcessTime", this.processingTime);
        output.putInt("Energy", this.energy);
    }
}

