/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.CustomSheets;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.ToolAnimationRenderer;
import com.mrcrayfish.furniture.refurbished.compat.jei.SyncedRecipes;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.FrameGraphSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="refurbished_furniture", value={Dist.CLIENT})
public class NeoForgeClientEvents {
    @SubscribeEvent
    private static void onKeyTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getKeyMapping() == mc.options.keyAttack && mc.player != null && mc.level != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get()) && LinkHandler.get().onWrenchLeftClick((Level)mc.level)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    private static void onRenderLevelStage(RenderLevelStageEvent.AfterBlockEntities event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        Vec3 view = event.getCamera().getPosition();
        stack.translate(-view.x(), -view.y(), -view.z());
        float deltaTick = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        LinkHandler.get().render((Player)mc.player, stack, event.getPartialTick());
        ToolAnimationRenderer.get().render((Level)mc.level, stack, mc.renderBuffers().bufferSource(), deltaTick);
        stack.popPose();
        mc.renderBuffers().bufferSource().endBatch(ClientServices.PLATFORM.getTelevisionScreenRenderType(CustomSheets.TV_CHANNELS_SHEET));
    }

    @SubscribeEvent
    private static void onDrawHighlight(RenderHighlightEvent.Block event) {
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND)).is((Item)ModItems.WRENCH.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSetupFrameGraph(FrameGraphSetupEvent event) {
        DeferredElectricRenderer.get().setupFramePass(event.getFrameGrapBuilder(), event.getCamera());
    }

    @SubscribeEvent
    public static void afterRenderLevel(RenderLevelStageEvent.AfterLevel event) {
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        if (!renderer.isIrisShadersEnabled()) {
            DeferredElectricRenderer.get().blitToScreen(event.getModelViewMatrix(), event.getCamera());
        }
    }

    @SubscribeEvent
    public static void onRecipesSynced(RecipesReceivedEvent event) {
        if (Services.PLATFORM.isModLoaded("jei")) {
            SyncedRecipes.setMap(event.getRecipeMap());
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        SyncedRecipes.reset();
    }
}

