/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.compat.jei.SyncedRecipes;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.CuttingBoardCombiningCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.CuttingBoardSlicingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FreezerSolidifyingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FryingPanCookingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.GrillCookingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.MicrowaveHeatingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.OvenBakingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.ToasterToastingCategory;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.WorkbenchConstructingCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class Plugin
implements IModPlugin {
    public static final ResourceLocation TEXTURES = Utils.resource("textures/gui/jei.png");
    public static final ResourceLocation TEXTURES_2 = Utils.resource("textures/gui/jei2.png");
    public static final DecimalFormat FORMATTER = new DecimalFormat("0.##s");

    public ResourceLocation getPluginUid() {
        return Utils.resource("plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FreezerSolidifyingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CuttingBoardSlicingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FryingPanCookingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MicrowaveHeatingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ToasterToastingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new GrillCookingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CuttingBoardCombiningCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkbenchConstructingCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new OvenBakingCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((IRecipeType)FreezerSolidifyingCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get()));
        registration.addRecipes((IRecipeType)CuttingBoardSlicingCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get()));
        registration.addRecipes((IRecipeType)FryingPanCookingCategory.TYPE.get(), this.getFryingPanRecipes());
        registration.addRecipes((IRecipeType)MicrowaveHeatingCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.MICROWAVE_HEATING.get()));
        registration.addRecipes((IRecipeType)ToasterToastingCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.TOASTER_HEATING.get()));
        registration.addRecipes((IRecipeType)GrillCookingCategory.TYPE.get(), this.getGrillRecipes());
        registration.addRecipes((IRecipeType)CuttingBoardCombiningCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get()));
        registration.addRecipes((IRecipeType)WorkbenchConstructingCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get()));
        registration.addRecipes((IRecipeType)OvenBakingCategory.TYPE.get(), this.getRecipes((RecipeType)ModRecipeTypes.OVEN_BAKING.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(RecipeTypes.SMELTING_FUEL, new ItemStack[]{new ItemStack((ItemLike)ModBlocks.ELECTRICITY_GENERATOR_LIGHT.get())});
        registration.addCraftingStation(RecipeTypes.SMELTING_FUEL, new ItemStack[]{new ItemStack((ItemLike)ModBlocks.ELECTRICITY_GENERATOR_DARK.get())});
        registration.addCraftingStation((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, new ItemStack[]{new ItemStack((ItemLike)ModBlocks.FRYING_PAN.get())});
        registration.addCraftingStation((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, new ItemStack[]{new ItemStack((ItemLike)ModBlocks.GRILL_RED.get())});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiScreenHandler(ComputerScreen.class, (IScreenHandler)new IScreenHandler<ComputerScreen>(this){

            @Nullable
            public IGuiProperties apply(ComputerScreen guiScreen) {
                return null;
            }
        });
    }

    private <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getRecipes(RecipeType<T> type) {
        return List.copyOf(SyncedRecipes.getMap().byType(type));
    }

    private List<RecipeHolder<ProcessingRecipe.Item>> getFryingPanRecipes() {
        ArrayList<RecipeHolder<ProcessingRecipe.Item>> holders = new ArrayList<RecipeHolder<ProcessingRecipe.Item>>();
        holders.addAll(this.getRecipes((RecipeType)ModRecipeTypes.FRYING_PAN_COOKING.get()));
        return this.mergeWithCampfireRecipeHolders(holders);
    }

    private List<RecipeHolder<ProcessingRecipe.Item>> getGrillRecipes() {
        ArrayList<RecipeHolder<ProcessingRecipe.Item>> holders = new ArrayList<RecipeHolder<ProcessingRecipe.Item>>();
        holders.addAll(this.getRecipes((RecipeType)ModRecipeTypes.GRILL_COOKING.get()));
        return this.mergeWithCampfireRecipeHolders(holders);
    }

    private List<RecipeHolder<ProcessingRecipe.Item>> mergeWithCampfireRecipeHolders(List<RecipeHolder<ProcessingRecipe.Item>> holders) {
        if (((Boolean)Config.SERVER.recipes.inheritCampfireRecipes.get()).booleanValue()) {
            holders.addAll(this.getRecipes(RecipeType.CAMPFIRE_COOKING).stream().map(holder -> Pair.of((Object)holder.id(), (Object)ProcessingRecipe.Item.fromCookingRecipe((AbstractCookingRecipe)holder.value(), Plugin.getRegistryAccess()))).map(pair -> {
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)((ResourceKey)pair.left()).location());
                return new RecipeHolder(key, (Recipe)((ProcessingRecipe.Item)pair.right()));
            }).toList());
        }
        return holders;
    }

    public static Font getFont() {
        return Minecraft.getInstance().font;
    }

    private static RegistryAccess getRegistryAccess() {
        ClientPacketListener listener = Objects.requireNonNull(Minecraft.getInstance().getConnection());
        return listener.registryAccess();
    }

    public static List<ItemStack> getTagItems(TagKey<Item> tag) {
        return StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(tag).spliterator(), false).map(holder -> new ItemStack((ItemLike)holder.value())).toList();
    }

    public static List<Component> getItemTooltip(ItemLike item) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        boolean advanced = minecraft.options.advancedItemTooltips;
        return new ItemStack(item).getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)player, (TooltipFlag)(advanced ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }
}

