/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MailboxItem
extends BlockItem {
    public MailboxItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = context.getPlayer();
            if (level instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)level;
                DeliveryService service = DeliveryService.get(level2.getServer()).orElse(null);
                if (service != null) {
                    if (!service.canCreateMailbox((Player)player)) {
                        int maxCount = (Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get();
                        player.sendSystemMessage(Components.GUI_MAIL_BOX_LIMIT.apply(maxCount), true);
                        return false;
                    }
                    return super.canPlace(context, state);
                }
                return false;
            }
        }
        return super.canPlace(context, state);
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!DeliveryService.isDeliverableDimension(context.getLevel())) {
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Utils.translation("gui", "invalid_dimension", new Object[0]), true);
            }
            return InteractionResult.FAIL;
        }
        return super.place(context);
    }
}

