/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.app;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.blockentity.IComputer;
import com.mrcrayfish.furniture.refurbished.computer.IService;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class PaddleBall
extends Program {
    public static final MatchmakingService SERVICE = new MatchmakingService();
    public static final int BOARD_WIDTH = 200;
    public static final int BOARD_HEIGHT = 100;
    public static final int PADDLE_WIDTH = 4;
    public static final int PADDLE_HEIGHT = 28;
    public static final float PADDLE_SPEED = 4.0f;
    public static final int RESET_COOLDOWN = 40;
    public static final int POINTS_TO_WIN = 7;
    public static final byte EVENT_GAME_START = 1;
    public static final byte EVENT_GAME_SIDE_LEFT = 2;
    public static final byte EVENT_GAME_SIDE_RIGHT = 3;
    public static final byte EVENT_GAME_WIN = 4;
    public static final byte EVENT_GAME_LOSE = 5;
    public static final byte EVENT_GAME_ROUND_WIN = 6;
    public static final byte EVENT_GAME_ROUND_LOSE = 7;
    public static final byte EVENT_GAME_OPPONENT_LEFT = 8;
    public static final byte EVENT_SOUND_HIT = 40;
    private State state = State.MAIN_MENU;
    @Nullable
    private Game activeGame;
    @Nullable
    private PlayerController controller;

    public PaddleBall(class_2960 id, IComputer computer) {
        super(id, computer);
    }

    @Override
    public void tick() {
        if (this.computer.isServer() && this.activeGame != null && (this.computer.getUser() == null || this.activeGame.finished)) {
            this.state = State.MAIN_MENU;
            this.activeGame = null;
            this.controller = null;
        }
    }

    @Override
    public void onClose(boolean remote) {
        this.activeGame = null;
    }

    public void update(Action action, byte data) {
        if (action == Action.JOIN_GAME && this.activeGame == null) {
            if (data == 0) {
                this.controller = new PlayerController(this.computer.getUser(), this);
                SERVICE.createAiGame(this.controller);
                this.state = State.IN_GAME;
            } else if (data == 1) {
                this.controller = new PlayerController(this.computer.getUser(), this);
                Game game = SERVICE.createMultiplayerGame(this.controller);
                this.state = game.isRunning() ? State.IN_GAME : State.PENDING;
            }
        } else if (action == Action.UPDATE_STATE) {
            if (data == 0) {
                this.state = State.MAIN_MENU;
                this.activeGame = null;
                this.controller = null;
            } else if (data == 1) {
                this.state = State.PENDING;
            } else if (data == 2) {
                this.state = State.IN_GAME;
            }
        } else if (action == Action.INPUT && this.controller != null) {
            this.controller.setInputUp(data == 1);
            this.controller.setInputDown(data == 2);
        }
    }

    public static enum State {
        MAIN_MENU,
        PENDING,
        IN_GAME;

    }

    protected static class Game {
        private final class_5819 random = class_5819.method_43047();
        private final Controller host;
        private Controller opponent;
        private Ball ball;
        private Difficulty difficulty;
        private boolean running;
        private boolean freezePaddles;
        private boolean finished;
        private int cooldown;

        private Game(PlayerController controller) {
            this.host = controller;
            controller.setSide(Side.LEFT);
            controller.setGame(this);
        }

        public Controller getHost() {
            return this.host;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setDifficulty(Difficulty difficulty) {
            this.difficulty = difficulty;
        }

        public void join(Controller controller) {
            if (this.opponent != null) {
                return;
            }
            controller.setGame(this);
            controller.setSide(Side.RIGHT);
            this.opponent = controller;
            this.startNewGame();
        }

        @Nullable
        protected Controller getOpponent(Controller self) {
            if (this.host == self) {
                return this.opponent;
            }
            return this.host;
        }

        public void update() {
            if (!this.host.isPlaying() || this.opponent != null && !this.opponent.isPlaying()) {
                this.sendEventToPlayers((byte)8);
                this.finished = true;
                this.running = false;
                return;
            }
            if (this.running && !this.finished) {
                if (this.cooldown-- > 0) {
                    if (this.cooldown == 0) {
                        this.resetBoard();
                    }
                    return;
                }
                this.ball.move();
                this.host.update();
                this.opponent.update();
                this.sendUpdateToPlayers(UpdateType.PADDLES);
                this.testForScore();
            }
        }

        private void startNewGame() {
            Preconditions.checkNotNull((Object)this.opponent, (Object)"Game cannot be started without an opponent present");
            this.sendEventToPlayers((byte)1);
            this.host.sendEvent((byte)2);
            this.opponent.sendEvent((byte)3);
            this.ball = new Ball(this);
            this.host.moveToCenter();
            this.opponent.moveToCenter();
            this.host.score = 0;
            this.opponent.score = 0;
            this.running = true;
            this.finished = false;
            this.freezePaddles = true;
            this.cooldown = 20;
            this.sendUpdateToPlayers(UpdateType.BALL);
            this.sendUpdateToPlayers(UpdateType.PADDLES);
            this.sendUpdateToPlayers(UpdateType.OPPONENT_NAME);
        }

        private void resetBoard() {
            Preconditions.checkNotNull((Object)this.opponent, (Object)"Board cannot be reset without an opponent present");
            this.ball = new Ball(this);
            this.ball.randomVelocity();
            this.host.moveToCenter();
            this.opponent.moveToCenter();
            this.freezePaddles = false;
            this.sendUpdateToPlayers(UpdateType.BALL);
            this.sendUpdateToPlayers(UpdateType.PADDLES);
        }

        private void testForScore() {
            if (this.ball.x1 <= 0.0f) {
                this.opponent.sendEvent((byte)6);
                this.host.sendEvent((byte)7);
                if (this.scoreAndCooldown(this.opponent)) {
                    this.opponent.sendEvent((byte)4);
                    this.host.sendEvent((byte)5);
                    this.finished = true;
                }
            } else if (this.ball.x2 >= 200.0f) {
                this.host.sendEvent((byte)6);
                this.opponent.sendEvent((byte)7);
                if (this.scoreAndCooldown(this.host)) {
                    this.host.sendEvent((byte)4);
                    this.opponent.sendEvent((byte)5);
                    this.finished = true;
                }
            }
        }

        private boolean scoreAndCooldown(Controller controller) {
            ++controller.score;
            if (controller.score >= 7) {
                return true;
            }
            this.freezePaddles = true;
            this.cooldown = 40;
            return false;
        }

        private void sendUpdateToPlayers(UpdateType type) {
            this.host.sendUpdate(type);
            if (this.opponent != null) {
                this.opponent.sendUpdate(type);
            }
        }

        private void sendEventToPlayers(byte event) {
            this.host.sendEvent(event);
            if (this.opponent != null) {
                this.opponent.sendEvent(event);
            }
        }

        public MessagePaddleBall.PaddlePosition createPaddlePositionMessage() {
            return new MessagePaddleBall.PaddlePosition(this.host.pos.y, this.opponent.pos.y);
        }

        public MessagePaddleBall.BallUpdate createBallUpdateMessage() {
            return new MessagePaddleBall.BallUpdate(this.ball.pos.x, this.ball.pos.y, this.ball.velocity.x, this.ball.velocity.y);
        }
    }

    protected static class PlayerController
    extends Controller {
        protected final class_1657 player;
        protected final PaddleBall program;
        protected boolean inputUp;
        protected boolean inputDown;

        private PlayerController(class_1657 player, PaddleBall program) {
            this.player = player;
            this.program = program;
        }

        public void setInputUp(boolean inputUp) {
            this.inputUp = inputUp;
        }

        public void setInputDown(boolean inputDown) {
            this.inputDown = inputDown;
        }

        @Override
        protected String getName() {
            return Optional.ofNullable(this.player.method_7334().getName()).orElse("Player");
        }

        @Override
        public boolean isPlaying() {
            IComputer computer = this.program.getComputer();
            return this.player.equals((Object)computer.getUser()) && computer.getProgram() == this.program && this.program.activeGame == this.game;
        }

        @Override
        public void update() {
            if (!this.game.freezePaddles) {
                this.pos.y = this.pos.y + (this.inputUp && !this.inputDown ? -4.0f : (!this.inputUp && this.inputDown ? 4.0f : 0.0f));
                this.pos.y = class_3532.method_15363((float)this.pos.y, (float)3.0f, (float)69.0f);
                this.updateBoundingBox();
            }
        }

        @Override
        public void sendUpdate(UpdateType type) {
            Controller opponent;
            class_3222 player;
            if (!this.isPlaying()) {
                return;
            }
            if (UpdateType.BALL.is(type)) {
                player = (class_3222)this.player;
                Network.getPlay().sendToPlayer(() -> player, (Object)this.game.createBallUpdateMessage());
            }
            if (UpdateType.PADDLES.is(type)) {
                player = (class_3222)this.player;
                Network.getPlay().sendToPlayer(() -> player, (Object)this.game.createPaddlePositionMessage());
            }
            if (UpdateType.OPPONENT_NAME.is(type) && (opponent = this.game.getOpponent(this)) != null) {
                class_3222 player2 = (class_3222)this.player;
                Network.getPlay().sendToPlayer(() -> player2, (Object)new MessagePaddleBall.OpponentName(opponent.getName()));
            }
        }

        @Override
        public void sendEvent(byte event) {
            if (!this.isPlaying()) {
                return;
            }
            class_3222 player = (class_3222)this.player;
            Network.getPlay().sendToPlayer(() -> player, (Object)new MessagePaddleBall.Event(event));
        }

        @Override
        public void setGame(Game game) {
            super.setGame(game);
            this.program.activeGame = game;
        }
    }

    public static enum Action {
        JOIN_GAME,
        UPDATE_STATE,
        INPUT;

    }

    public static class MatchmakingService
    implements IService {
        private final Queue<Game> pendingGames = new ArrayDeque<Game>();
        private final List<Game> activeGames = new ArrayList<Game>();

        protected Game createAiGame(PlayerController controller) {
            Game game = new Game(controller);
            game.setDifficulty(Difficulty.HARD);
            game.join(new AiController());
            this.activeGames.add(game);
            return game;
        }

        protected Game createMultiplayerGame(PlayerController controller) {
            if (!this.pendingGames.isEmpty()) {
                Game game = this.pendingGames.poll();
                game.join(controller);
                this.activeGames.add(game);
                return game;
            }
            Game game = new Game(controller);
            game.setDifficulty(Difficulty.HARD);
            this.pendingGames.offer(game);
            return game;
        }

        @Override
        public void tick() {
            this.pendingGames.removeIf(game -> !game.getHost().isPlaying());
            this.activeGames.removeIf(Game::isFinished);
            this.activeGames.forEach(Game::update);
        }
    }

    public static enum UpdateType {
        BALL,
        PADDLES,
        OPPONENT_NAME;


        public boolean is(UpdateType type) {
            return this == type;
        }
    }

    public static enum Difficulty {
        EASY(3.5f, 4.0f, 5.0f),
        MEDIUM(4.0f, 8.0f, 6.0f),
        HARD(5.0f, 15.0f, 8.0f);

        private final float aiPaddleSpeed;
        private final float aiTolerance;
        private final float ballYSpeed;

        private Difficulty(float aiPaddleSpeed, float aiTolerance, float ballYSpeed) {
            this.aiPaddleSpeed = aiPaddleSpeed;
            this.aiTolerance = aiTolerance;
            this.ballYSpeed = ballYSpeed;
        }
    }

    public static enum Side {
        LEFT(4),
        RIGHT(192);

        private final int position;

        private Side(int position) {
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static class Ball
    extends GameObject {
        protected Vector2f velocity = new Vector2f();

        protected Ball(Game game) {
            super(4.0f, 4.0f);
            this.game = game;
            this.pos = new Vector2f(100.0f, 48.0f);
            this.updateBoundingBox();
        }

        public void randomVelocity() {
            this.velocity.x = 8.0f;
            this.reflectYVelocity(this.game.random.method_43057());
        }

        public void move() {
            this.pos.add((Vector2fc)this.velocity);
            this.updateBoundingBox();
            if (this.performCollision()) {
                this.game.sendUpdateToPlayers(UpdateType.BALL);
                this.game.sendEventToPlayers((byte)40);
            }
        }

        @Override
        protected void updateBoundingBox() {
            this.updateBoundingBox(this.pos.x - 2.0f, this.pos.y - 2.0f);
        }

        public void reflectYVelocity(float hit) {
            hit = Math.clamp((float)hit, (float)0.0f, (float)1.0f);
            hit = (hit - 0.5f) * 2.0f;
            this.velocity.y = this.game.difficulty.ballYSpeed * hit;
        }

        private boolean performCollision() {
            Vector2f point;
            float endX;
            float startX;
            boolean collided = false;
            if (this.velocity.y < 0.0f && this.y1 < 0.0f && Intersectionf.intersectLineLine((float)(startX = -100.0f), (float)0.0f, (float)(endX = 300.0f), (float)0.0f, (float)this.x1, (float)this.y1, (float)(this.x1 - this.velocity.x), (float)(this.y1 - this.velocity.y), (Vector2f)(point = new Vector2f()))) {
                this.pos.x = point.x + 2.0f;
                this.pos.y = point.y + 2.0f;
                this.velocity.y = -this.velocity.y;
                this.updateBoundingBox();
                collided = true;
            }
            if (this.velocity.y > 0.0f && this.y2 > 100.0f && Intersectionf.intersectLineLine((float)(startX = -100.0f), (float)100.0f, (float)(endX = 300.0f), (float)100.0f, (float)this.x2, (float)this.y2, (float)(this.x2 - this.velocity.x), (float)(this.y2 - this.velocity.y), (Vector2f)(point = new Vector2f()))) {
                this.pos.x = point.x - 2.0f;
                this.pos.y = point.y - 2.0f;
                this.velocity.y = -this.velocity.y;
                this.updateBoundingBox();
                collided = true;
            }
            if (this.velocity.x < 0.0f && this.x1 < this.game.host.x2) {
                boolean checkBottomCorner = true;
                Vector2f point2 = new Vector2f();
                if (Intersectionf.intersectLineLine((float)this.game.host.x2, (float)this.game.host.y1, (float)this.game.host.x2, (float)this.game.host.y2, (float)this.x1, (float)this.y1, (float)(this.x1 - this.velocity.x), (float)(this.y1 - this.velocity.y), (Vector2f)point2) && point2.y >= this.game.host.y1 && point2.y < this.game.host.y2) {
                    this.pos.x = point2.x + 2.0f;
                    this.pos.y = point2.y + 2.0f;
                    this.velocity.x = -this.velocity.x;
                    this.reflectYVelocity((this.pos.y - this.game.host.y1) / 28.0f);
                    this.updateBoundingBox();
                    collided = true;
                    checkBottomCorner = false;
                }
                if (checkBottomCorner && Intersectionf.intersectLineLine((float)this.game.host.x2, (float)this.game.host.y1, (float)this.game.host.x2, (float)this.game.host.y2, (float)this.x1, (float)this.y2, (float)(this.x1 - this.velocity.x), (float)(this.y2 - this.velocity.y), (Vector2f)point2) && point2.y > this.game.host.y1 && point2.y < this.game.host.y2) {
                    this.pos.x = point2.x + 2.0f;
                    this.pos.y = point2.y - 2.0f;
                    this.velocity.x = -this.velocity.x;
                    this.reflectYVelocity((this.pos.y - this.game.host.y1) / 28.0f);
                    this.updateBoundingBox();
                    collided = true;
                }
            }
            if (this.velocity.x > 0.0f && this.x2 > this.game.opponent.x1) {
                boolean checkBottomCorner = true;
                Vector2f point3 = new Vector2f();
                if (Intersectionf.intersectLineLine((float)this.game.opponent.x1, (float)this.game.opponent.y1, (float)this.game.opponent.x1, (float)this.game.opponent.y2, (float)this.x2, (float)this.y1, (float)(this.x2 - this.velocity.x), (float)(this.y1 - this.velocity.y), (Vector2f)point3) && point3.y > this.game.opponent.y1 && point3.y < this.game.opponent.y2) {
                    this.pos.x = point3.x - 2.0f;
                    this.pos.y = point3.y + 2.0f;
                    this.velocity.x = -this.velocity.x;
                    this.reflectYVelocity((this.pos.y - this.game.opponent.y1) / 28.0f);
                    this.updateBoundingBox();
                    collided = true;
                    checkBottomCorner = false;
                }
                if (checkBottomCorner && Intersectionf.intersectLineLine((float)this.game.opponent.x1, (float)this.game.opponent.y1, (float)this.game.opponent.x1, (float)this.game.opponent.y2, (float)this.x2, (float)this.y2, (float)(this.x2 - this.velocity.x), (float)(this.y2 - this.velocity.y), (Vector2f)point3) && point3.y >= this.game.opponent.y1 && point3.y <= this.game.opponent.y2) {
                    this.pos.x = point3.x - 2.0f;
                    this.pos.y = point3.y - 2.0f;
                    this.velocity.x = -this.velocity.x;
                    this.reflectYVelocity((this.pos.y - this.game.opponent.y1) / 28.0f);
                    this.updateBoundingBox();
                    collided = true;
                }
            }
            return collided;
        }
    }

    protected static class AiController
    extends Controller {
        protected AiController() {
        }

        @Override
        protected String getName() {
            return "AI";
        }

        @Override
        public boolean isPlaying() {
            return true;
        }

        @Override
        public void update() {
            if (!this.game.freezePaddles && this.game.ball.velocity.x > 0.0f) {
                float tolerance = this.game.difficulty.aiTolerance;
                float paddleSpeed = this.game.difficulty.aiPaddleSpeed;
                if (this.game.ball.pos.y < this.pos.y + 14.0f - tolerance) {
                    this.pos.y -= Math.min((float)paddleSpeed, (float)(this.pos.y + 14.0f - this.game.ball.pos.y));
                } else if (this.game.ball.pos.y > this.pos.y + 14.0f + tolerance) {
                    this.pos.y += Math.min((float)paddleSpeed, (float)(this.game.ball.pos.y - this.pos.y + 14.0f));
                }
                this.pos.y = class_3532.method_15363((float)this.pos.y, (float)3.0f, (float)69.0f);
                this.updateBoundingBox(this.pos.x, this.pos.y);
            }
        }
    }

    protected static abstract class Controller
    extends GameObject {
        protected Side side = Side.LEFT;
        protected int score;

        public Controller() {
            super(4.0f, 28.0f);
            this.moveToCenter();
        }

        protected abstract boolean isPlaying();

        protected abstract void update();

        protected abstract String getName();

        public void setSide(Side side) {
            this.side = side;
            if (this.pos != null) {
                this.pos.x = side.getPosition();
            }
        }

        public void moveToCenter() {
            this.pos = new Vector2f((float)this.side.getPosition(), 36.0f);
            this.updateBoundingBox();
        }

        public void sendUpdate(UpdateType type) {
        }

        public void sendEvent(byte event) {
        }
    }

    protected static abstract class GameObject {
        protected final float width;
        protected final float height;
        protected float x1;
        protected float y1;
        protected float x2;
        protected float y2;
        protected Vector2f pos = new Vector2f();
        protected Game game;

        public GameObject(float width, float height) {
            this.width = width;
            this.height = height;
            this.updateBoundingBox(0.0f, 0.0f);
        }

        protected void updateBoundingBox() {
            this.updateBoundingBox(this.pos.x, this.pos.y);
        }

        protected void updateBoundingBox(float x, float y) {
            this.x1 = x;
            this.y1 = y;
            this.x2 = x + this.width;
            this.y2 = y + this.height;
        }

        public void setGame(Game game) {
            this.game = game;
        }
    }
}

