/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.framework.api.datagen.FrameworkGenerator;
import com.mrcrayfish.framework.api.datagen.FrameworkModelProvider;
import com.mrcrayfish.furniture.refurbished.Bootstrap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.data.CommonBlockStatesGenerator;
import com.mrcrayfish.furniture.refurbished.data.CommonBlockTagsProvider;
import com.mrcrayfish.furniture.refurbished.data.CommonItemModelsGenerator;
import com.mrcrayfish.furniture.refurbished.data.CommonItemTagsProvider;
import com.mrcrayfish.furniture.refurbished.data.CommonLootTableProvider;
import com.mrcrayfish.furniture.refurbished.data.CommonRecipeProvider;
import com.mrcrayfish.furniture.refurbished.data.RegistriesProvider;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.platform.NeoForgeFluidHelper;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

@Mod(value="refurbished_furniture")
public class FurnitureMod {
    public FurnitureMod(IEventBus bus) {
        NeoForgeMod.enableMilkFluid();
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onGatherData);
        bus.addListener(this::onRegisterCapabilities);
        NeoForge.EVENT_BUS.addListener(this::onDatapackSync);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Bootstrap::init);
    }

    private void onGatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        CommonBlockTagsProvider blockTagsProvider = (CommonBlockTagsProvider)event.createProvider(CommonBlockTagsProvider::new);
        event.addProvider((DataProvider)new CommonItemTagsProvider(output, lookupProvider, blockTagsProvider.contentsGetter()));
        event.addProvider((DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, RegistriesProvider.BUILDER, Set.of("refurbished_furniture")));
        event.addProvider((DataProvider)new FrameworkModelProvider(output, new FrameworkGenerator.Factory[]{CommonBlockStatesGenerator::new, CommonItemModelsGenerator::new}));
        event.createProvider(CommonLootTableProvider::new);
        event.createProvider(CommonRecipeProvider.Runner::new);
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.FREEZER.get(), (entity, context) -> context == Direction.DOWN ? new SidedInvWrapper((WorldlyContainer)entity, Direction.DOWN) : new InvWrapper((Container)entity));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.STOVE.get(), (entity, context) -> context == Direction.DOWN ? new SidedInvWrapper(entity.getContainer(), Direction.DOWN) : new InvWrapper((Container)entity));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.RECYCLE_BIN.get(), (entity, context) -> context == Direction.DOWN ? new SidedInvWrapper((WorldlyContainer)entity, Direction.DOWN) : new SidedInvWrapper((WorldlyContainer)entity, Direction.UP));
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.BATH.get());
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.KITCHEN_SINK.get());
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.BASIN.get());
        this.registerFluidHandler(event, (BlockEntityType)ModBlockEntities.TOILET.get());
    }

    private <T extends BlockEntity> void registerFluidHandler(RegisterCapabilitiesEvent event, BlockEntityType<T> type) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, type, (entity, context) -> {
            FluidContainer container = ((IFluidContainerBlock)entity).getFluidContainer();
            return container != null ? ((NeoForgeFluidHelper.NeoForgeFluidContainer)container).getTank() : EmptyFluidHandler.INSTANCE;
        });
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        RecipeManager manager = event.getPlayerList().getServer().getRecipeManager();
        List recipes = List.copyOf(manager.recipeMap().byType((RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get()));
        event.getRelevantPlayers().forEach(player -> Network.getPlay().sendToPlayer(() -> player, (Object)new MessageWorkbench.SyncRecipes(recipes)));
    }
}

