/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DoorbellBlockEntity
extends ElectricityModuleBlockEntity
implements INameable {
    public static final int MAX_NAME_LENGTH = 32;
    protected UUID owner;
    protected String customName = "";
    protected long lastPressedTime;
    protected boolean powered;

    public DoorbellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DOORBELL.get(), pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.setChanged();
        if (!this.level.isClientSide()) {
            BlockEntityHelper.sendCustomUpdate(this, (entity, access) -> {
                CompoundTag compound = new CompoundTag();
                compound.putBoolean("Powered", powered);
                return compound;
            });
        }
    }

    @Override
    public void setName(@Nullable ServerPlayer player, String name) {
        if (this.owner == null || player == null) {
            return;
        }
        if (!this.owner.equals(player.getUUID())) {
            return;
        }
        if (!name.isBlank()) {
            this.customName = StringUtils.truncate((String)name, (int)32);
            this.setChanged();
        }
    }

    public void sendNotificationToOwner(@Nullable Player presser) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.owner != null) {
                MinecraftServer server = level2.getServer();
                ServerPlayer player = server.getPlayerList().getPlayer(this.owner);
                if (player == null || level2.getGameTime() - this.lastPressedTime < 600L) {
                    return;
                }
                if (presser != null && presser.equals((Object)player)) {
                    return;
                }
                Network.getPlay().sendToPlayer(() -> player, (Object)new MessageDoorbellNotification(this.customName));
                this.lastPressedTime = level2.getGameTime();
            }
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        tag.read("Owner", UUIDUtil.CODEC).ifPresent(value -> {
            this.owner = value;
        });
        tag.getBoolean("Powered").ifPresent(value -> {
            this.powered = value;
        });
        this.customName = tag.getStringOr("CustomName", "");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            tag.store("Owner", UUIDUtil.CODEC, (Object)this.owner);
        }
        tag.putBoolean("Powered", this.powered);
        tag.putString("CustomName", this.customName);
    }
}

