/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.MailboxBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.blockentity.RowedStorageBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MailboxBlockEntity
extends RowedStorageBlockEntity
implements INameable {
    protected UUID uuid = UUID.randomUUID();
    protected WeakReference<Mailbox> mailboxRef;

    public MailboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MAIL_BOX.get(), pos, state, (Integer)Config.SERVER.mailing.mailboxInventoryRows.get());
    }

    public UUID getId() {
        return this.uuid;
    }

    public void regenerateId() {
        this.uuid = UUID.randomUUID();
        this.setChanged();
    }

    @Override
    public void setName(@Nullable ServerPlayer player, String name) {
        if (player == null) {
            return;
        }
        DeliveryService.get(player.server).ifPresent(service -> {
            if (!service.renameMailbox((Player)player, player.level(), this.worldPosition, name)) {
                player.sendSystemMessage((Component)Utils.translation("gui", "rename_mailbox_failed", new Object[0]));
            }
        });
    }

    public boolean deliverItem(ItemStack mail) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) {
                this.setItem(i, mail);
                this.setUnchecked();
                return true;
            }
            if (stack.getCount() == stack.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)mail) || stack.getCount() + mail.getCount() > stack.getMaxStackSize()) continue;
            stack.grow(mail.getCount());
            this.setChanged();
            this.setUnchecked();
            return true;
        }
        return false;
    }

    public void setUnchecked() {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MailboxBlock.ENABLED, (Comparable)Boolean.valueOf(true)), 3);
    }

    public Mailbox getMailbox() {
        ServerLevel serverLevel;
        Optional<DeliveryService> optional;
        Level level;
        if (this.mailboxRef != null) {
            Mailbox mailbox = (Mailbox)this.mailboxRef.get();
            if (mailbox != null && !mailbox.removed().booleanValue()) {
                return mailbox;
            }
            this.mailboxRef = null;
        }
        if ((level = this.level) instanceof ServerLevel && (optional = DeliveryService.get((serverLevel = (ServerLevel)level).getServer())).isPresent()) {
            DeliveryService service = optional.get();
            Mailbox mailbox = service.getOrCreateMailBox(this);
            this.mailboxRef = new WeakReference<Mailbox>(mailbox);
            return mailbox;
        }
        return null;
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "mailbox", new Object[0]);
    }

    public Component getDisplayName() {
        String customName;
        Mailbox mailbox = this.getMailbox();
        if (mailbox != null && (customName = (String)mailbox.customName().getValue()) != null && !customName.isBlank()) {
            return Component.literal((String)customName);
        }
        return super.getDisplayName();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("UUID")) {
            this.uuid = tag.read("UUID", UUIDUtil.CODEC).orElse(UUID.randomUUID());
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.store("UUID", UUIDUtil.CODEC, (Object)this.uuid);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Optional.ofNullable(this.getMailbox()).ifPresent(Mailbox::remove);
    }
}

