/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.MicrowaveBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MicrowaveBlockEntity
extends ElectricityModuleProcessingLootBlockEntity
implements IPowerSwitch,
IHomeControlDevice,
ILevelAudio,
Nameable,
StackedContentsCompatible {
    public static final int[] INPUT_SLOTS = new int[]{0};
    public static final int[] OUTPUT_SLOTS = new int[]{1};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESS_TIME = 2;
    public static final int DATA_MAX_PROCESS_TIME = 3;
    public static final double MAX_AUDIO_DISTANCE = Mth.square((double)3.5);
    protected final Vec3 audioPosition;
    protected boolean enabled;
    protected boolean processing;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {
            this.processingTime = value;
        });
        builder.add(3, () -> this.totalProcessingTime, value -> {
            this.totalProcessingTime = value;
        });
    });

    public MicrowaveBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.MICROWAVE.get(), pos, state, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.MICROWAVE_HEATING.get()));
    }

    public MicrowaveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, 2, recipeType);
        this.audioPosition = pos.getCenter();
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "microwave", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return Services.MENU.createMicrowaveMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    public boolean canProcess() {
        return super.canProcess() && this.enabled;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_MICROWAVE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_MICROWAVE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)MicrowaveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.setChanged();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        tag.getBoolean("Enabled").ifPresent(value -> {
            this.enabled = value;
        });
        tag.getBoolean("Processing").ifPresent(value -> {
            this.processing = value;
        });
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("Enabled", this.enabled);
        tag.putBoolean("Processing", this.processing);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putBoolean("Enabled", this.enabled);
        tag.putBoolean("Processing", this.processing);
        BlockEntityHelper.saveCustomName(tag, this.getCustomName(), provider);
        return tag;
    }

    @Override
    public BlockPos getDevicePos() {
        return this.worldPosition;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.setChanged();
        this.syncDataToTrackingClients();
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.setChanged();
        this.syncDataToTrackingClients();
    }

    @Override
    public Component getDeviceName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return this.getDefaultName();
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_MICROWAVE_FAN.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && this.processing && this.enabled && !this.isRemoved();
    }

    @Override
    public int getAudioHash() {
        return this.worldPosition.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    @Override
    public void moduleTick(Level level) {
        super.moduleTick(level);
        if (!level.isClientSide) {
            boolean processing = this.processTick();
            if (this.processing != processing) {
                this.processing = processing;
                this.syncDataToTrackingClients();
            }
        } else {
            AudioManager.get().playLevelAudio(this);
        }
    }

    public void fillStackedContents(StackedItemContents contents) {
        for (ItemStack stack : this.items) {
            contents.accountStack(stack);
        }
    }
}

