/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.core.ModRenderPipelines;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class DeferredElectricRenderer
implements ResourceManagerReloadListener {
    public static final String PASS_NAME = "refurbished_furniture_electricity";
    public static final ResourceLocation ID = Utils.resource("deferred_electric_renderer");
    private static DeferredElectricRenderer instance;
    private final ResourceLocation nodeTexture = Utils.resource("textures/misc/electricity_nodes.png");
    private final List<BiConsumer<PoseStack, VertexConsumer>> deferredDrawCalls = new LinkedList<BiConsumer<PoseStack, VertexConsumer>>();
    private final RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
    @Nullable
    private Class<?> irisClass;
    private Method shaderPack;
    private Boolean shaderEnabled;
    private TextureTarget electricityTarget;
    private ResourceHandle<TextureTarget> handle;

    public static DeferredElectricRenderer get() {
        if (instance == null) {
            instance = new DeferredElectricRenderer();
        }
        return instance;
    }

    private DeferredElectricRenderer() {
        this.setupIrisSupport();
    }

    private void setupIrisSupport() {
        try {
            this.irisClass = Class.forName("net.irisshaders.iris.Iris");
            this.shaderPack = this.irisClass.getDeclaredMethod("getCurrentPack", new Class[0]);
            this.shaderPack.setAccessible(true);
            Constants.LOG.info("Iris detected! Will use modified rendering for electricity when shaders are enabled");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to locate Iris shader pack getter", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public boolean isIrisShadersEnabled() {
        if (this.irisClass != null && this.shaderPack != null && this.shaderEnabled == null) {
            try {
                Optional optional = (Optional)this.shaderPack.invoke(null, new Object[0]);
                this.shaderEnabled = optional.isPresent();
                return this.shaderEnabled;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke shader pack getter", e);
            }
        }
        return this.shaderEnabled != null && this.shaderEnabled != false;
    }

    public void onResourceManagerReload(ResourceManager manager) {
        if (this.electricityTarget != null) {
            this.electricityTarget.destroyBuffers();
        }
        Window window = Minecraft.getInstance().getWindow();
        this.electricityTarget = new TextureTarget("Refurbished Furniture Electricity Overlay", window.getWidth(), window.getHeight(), true);
    }

    public void resize(int width, int height) {
        if (this.electricityTarget != null) {
            this.electricityTarget.resize(width, height);
        }
    }

    public void deferDraw(BiConsumer<PoseStack, VertexConsumer> consumer) {
        this.deferredDrawCalls.add(consumer);
    }

    public void setupFramePass(FrameGraphBuilder builder, Camera camera) {
        this.shaderEnabled = null;
        if (this.electricityTarget != null && LinkHandler.isHoldingWrench()) {
            ResourceHandle handle = builder.importExternal(PASS_NAME, (Object)this.electricityTarget);
            FramePass pass = builder.addPass(PASS_NAME);
            this.handle = pass.readsAndWrites(handle);
            pass.executes(() -> {
                GpuTexture colorTexture = this.electricityTarget.getColorTexture();
                GpuTexture depthTexture = this.electricityTarget.getDepthTexture();
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(colorTexture, 0, depthTexture, 1.0);
                if (!this.isIrisShadersEnabled()) {
                    PoseStack stack = new PoseStack();
                    Vec3 view = camera.getPosition();
                    stack.translate(-view.x(), -view.y(), -view.z());
                    this.drawDeferredCalls(stack);
                }
            });
        } else {
            this.deferredDrawCalls.clear();
        }
    }

    private void drawDeferredCalls(PoseStack pose) {
        if (this.deferredDrawCalls.isEmpty()) {
            return;
        }
        RenderPipeline pipeline = ModRenderPipelines.ELECTRICITY;
        try (ByteBufferBuilder quadBuilder = new ByteBufferBuilder(pipeline.getVertexFormat().getVertexSize() * 4);){
            BufferBuilder vertexBuilder = new BufferBuilder(quadBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
            this.deferredDrawCalls.forEach(consumer -> consumer.accept(pose, vertexBuilder));
            try (MeshData data = vertexBuilder.build();){
                this.uploadMeshToElectricityTexture(data);
            }
        }
        this.deferredDrawCalls.clear();
    }

    private void uploadMeshToElectricityTexture(@Nullable MeshData data) {
        if (data == null) {
            return;
        }
        TextureTarget target = this.electricityTarget;
        RenderPipeline pipeline = ModRenderPipelines.ELECTRICITY;
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(this.nodeTexture);
        RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)pipeline.getVertexFormatMode());
        VertexFormat.IndexType indexType = autoIndexBuffer.type();
        GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(data.drawState().indexCount());
        GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Deferred Electricity Renderer", BufferType.VERTICES, BufferUsage.DYNAMIC_WRITE, data.vertexBuffer().remaining());
        RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer, data.vertexBuffer(), 0);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(target.getColorTexture(), OptionalInt.empty(), target.getDepthTexture(), OptionalDouble.empty());){
            pass.setPipeline(pipeline);
            pass.setVertexBuffer(0, vertexBuffer);
            pass.setIndexBuffer(indexBuffer, indexType);
            pass.bindSampler("Sampler0", texture.getTexture());
            pass.drawIndexed(0, data.drawState().indexCount());
        }
    }

    public void blitToScreen(Matrix4f projMatrix, Camera camera) {
        if (this.isIrisShadersEnabled()) {
            PoseStack stack = new PoseStack();
            Vec3 view = camera.getPosition();
            stack.mulPose((Matrix4fc)projMatrix);
            stack.translate(-view.x(), -view.y(), -view.z());
            this.drawDeferredCalls(stack);
        }
        GpuTexture mainColor = Minecraft.getInstance().getMainRenderTarget().getColorTexture();
        GpuTexture electricityColor = this.electricityTarget.getColorTexture();
        if (this.handle != null && electricityColor != null && mainColor != null) {
            RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
            GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(6);
            GpuBuffer vertexBuffer = RenderSystem.getQuadVertexBuffer();
            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(mainColor, OptionalInt.empty());){
                pass.setPipeline(ModRenderPipelines.ELECTRICITY_BLIT);
                pass.setVertexBuffer(0, vertexBuffer);
                pass.setIndexBuffer(indexBuffer, autoIndexBuffer.type());
                pass.bindSampler("InSampler", electricityColor);
                pass.drawIndexed(0, 6);
            }
        }
        this.handle = null;
    }

    public void drawColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public void drawInvertedColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public void drawTexturedBox(Matrix4f matrix, VertexConsumer consumer, AABB box, float minU, float minV, float maxU, float maxV) {
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

