/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.WorkbenchScreen;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class ClientWorkbenchRecipeTooltip
implements ClientTooltipComponent {
    private final WorkbenchMenu menu;
    private final WorkbenchContructingRecipe recipe;
    private final List<DisplayStack> displayStacks;

    public ClientWorkbenchRecipeTooltip(WorkbenchMenu menu, WorkbenchContructingRecipe recipe) {
        this.menu = menu;
        this.recipe = recipe;
        this.displayStacks = recipe.getMaterials().stream().map(i -> new DisplayStack(-1L, ItemStack.EMPTY)).collect(Collectors.toList());
    }

    public int getHeight(Font font) {
        return 20;
    }

    public int getWidth(Font font) {
        return this.recipe.getMaterials().size() * 18;
    }

    public void renderImage(Font font, int start, int top, int width, int height, GuiGraphics graphics) {
        HashMap<Integer, Integer> counted = new HashMap<Integer, Integer>();
        NonNullList<StackedIngredient> materials = this.recipe.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            StackedIngredient material = (StackedIngredient)materials.get(i);
            ItemStack copy = this.getDisplayStack(i, material);
            graphics.renderFakeItem(copy, start + i * 18, top);
            graphics.renderItemDecorations(font, copy, start + i * 18, top);
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            boolean checked = this.menu.hasMaterials(material, counted);
            graphics.blit(RenderType::guiTextured, WorkbenchScreen.WORKBENCH_TEXTURE, start + i * 18, top, checked ? 246.0f : 240.0f, 40.0f, 6, 5, 256, 256);
            pose.popPose();
        }
    }

    private ItemStack getDisplayStack(int index, StackedIngredient material) {
        long time = Util.getMillis() / 1000L;
        DisplayStack display = this.displayStacks.get(index);
        if (display.lastUpdate != time) {
            List items = material.ingredient().items().toList();
            int itemIndex = (int)time % items.size();
            ItemStack stack = new ItemStack((Holder)items.get(itemIndex));
            stack.setCount(material.count());
            this.displayStacks.set(index, new DisplayStack(time, stack));
            return stack;
        }
        return display.stack;
    }

    private record DisplayStack(long lastUpdate, ItemStack stack) {
    }
}

