/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.ElectricityGeneratorMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ElectricityGeneratorScreen
extends AbstractContainerScreen<ElectricityGeneratorMenu> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/electricity_generator.png");
    protected OnOffSlider slider;

    public ElectricityGeneratorScreen(ElectricityGeneratorMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.slider = (OnOffSlider)this.addRenderableWidget((GuiEventListener)new OnOffSlider(this.leftPos + this.imageWidth - 22 - 6, this.topPos + 5, (Component)Utils.translation("gui", "generator_toggle", new Object[0]), btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((ElectricityGeneratorMenu)this.menu).isEnabled());
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((ElectricityGeneratorMenu)this.menu).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.menu).getTotalEnergy() > 0) {
            float normalEnergy = (float)((ElectricityGeneratorMenu)this.menu).getEnergy() / (float)((ElectricityGeneratorMenu)this.menu).getTotalEnergy();
            int v = (int)Math.ceil(14.0f * normalEnergy);
            graphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos + 26, this.topPos + 25 + 14 - v, 176.0f, (float)(14 - v), 14, v, 256, 256);
        }
        Status status = this.getStatus();
        graphics.blit(RenderType::guiTextured, IconButton.ICON_TEXTURES, this.leftPos + 66, this.topPos + 29, (float)status.iconU, (float)status.iconV, 10, 10, 64, 64);
        graphics.blit(RenderType::guiTextured, IconButton.ICON_TEXTURES, this.leftPos + 66, this.topPos + 46, 0.0f, 10.0f, 10, 10, 64, 64);
        if (((ElectricityGeneratorMenu)this.menu).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.menu).getTotalEnergy() > 0 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 26, this.topPos + 25, 14, 14)) {
            this.setTooltipForNextRenderPass((Component)Utils.translation("gui", "progress", ((ElectricityGeneratorMenu)this.menu).getEnergy(), Components.GUI_SLASH, ((ElectricityGeneratorMenu)this.menu).getTotalEnergy()));
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        Status status = this.getStatus();
        graphics.drawString(this.font, status.label, 80, 30, status.textColour, true);
        Pair<Component, Integer> pair = this.getNodeCount();
        graphics.drawString(this.font, (Component)pair.left(), 80, 47, ((Integer)pair.right()).intValue(), true);
    }

    private Pair<Component, Integer> getNodeCount() {
        int nodeCount = ((ElectricityGeneratorMenu)this.menu).getNodeCount();
        int maxNodeCount = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        MutableComponent label = Utils.translation("gui", "node_count", nodeCount, maxNodeCount);
        int textColour = nodeCount > maxNodeCount ? -3983818 : -1;
        return Pair.of((Object)label, (Object)textColour);
    }

    private Status getStatus() {
        if (((ElectricityGeneratorMenu)this.menu).isOverloaded()) {
            return Status.OVERLOADED;
        }
        if (((ElectricityGeneratorMenu)this.menu).isEnabled()) {
            if (((ElectricityGeneratorMenu)this.menu).isPowered()) {
                return Status.ONLINE;
            }
            if (((ElectricityGeneratorMenu)this.menu).getEnergy() == 0) {
                return Status.NO_FUEL;
            }
        }
        return Status.OFFLINE;
    }

    private static enum Status {
        ONLINE(-8799453, 50, 0, (Component)Utils.translation("gui", "status.online", new Object[0])),
        OFFLINE(-3983818, 40, 0, (Component)Utils.translation("gui", "status.offline", new Object[0])),
        OVERLOADED(-2711764, 30, 0, (Component)Utils.translation("gui", "status.overloaded", new Object[0])),
        NO_FUEL(-2711764, 10, 10, (Component)Utils.translation("gui", "status.no_fuel", new Object[0]));

        private final int textColour;
        private final int iconU;
        private final int iconV;
        private final Component label;

        private Status(int textColour, int iconU, int iconV, Component label) {
            this.textColour = textColour;
            this.iconU = iconU;
            this.iconV = iconV;
            this.label = label;
        }
    }
}

