/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWithdrawExperience;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.text.DecimalFormat;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Matrix4f;

public class RecyclingBinScreen
extends ElectricityContainerScreen<RecycleBinMenu> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.###");
    private static final ResourceLocation RECYCLING_BIN_TEXTURE = Utils.resource("textures/gui/container/recycle_bin.png");
    private OnOffSlider slider;
    private Button withdrawButton;

    public RecyclingBinScreen(RecycleBinMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageHeight = 193;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.slider = (OnOffSlider)this.addRenderableWidget((GuiEventListener)new OnOffSlider(this.leftPos + this.imageWidth - 22 - 6, this.topPos + 5, Components.GUI_TOGGLE_POWER, btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
        this.withdrawButton = (Button)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 7, this.topPos + 75, 20, 10, 162, Components.GUI_WITHDRAW_EXPERIENCE, btn -> Network.getPlay().sendToServer((Object)new MessageWithdrawExperience())));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((RecycleBinMenu)this.menu).isEnabled());
        this.withdrawButton.active = this.getExperiencePoints() >= 1.0;
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        graphics.blit(RenderType::guiTextured, RECYCLING_BIN_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((RecycleBinMenu)this.menu).getProcessTime() >= 0) {
            int maxProcessTime = (Integer)Config.SERVER.recycleBin.processingTime.get();
            int width = (int)Math.ceil(25.0f * ((float)((RecycleBinMenu)this.menu).getProcessTime() / (float)maxProcessTime));
            graphics.blit(RenderType::guiTextured, RECYCLING_BIN_TEXTURE, this.leftPos + 85, this.topPos + 28, 176.0f, 0.0f, width, 17, 256, 256);
        }
        int maxLevel = (Integer)Config.SERVER.recycleBin.maximumExperienceLevels.get();
        double currentLevel = Mth.clamp((double)this.getExperienceLevel(), (double)0.0, (double)maxLevel);
        MutableComponent levelLabel = Utils.translation("gui", "experience_level", FORMAT.format(currentLevel), maxLevel);
        int labelWidth = this.minecraft.font.width((FormattedText)levelLabel) / 2;
        Matrix4f matrix = graphics.pose().last().pose();
        MultiBufferSource.BufferSource source = this.minecraft.renderBuffers().bufferSource();
        this.minecraft.font.drawInBatch8xOutline(levelLabel.getVisualOrderText(), (float)(this.leftPos + 68 - labelWidth), (float)(this.topPos + 60), -3604593, -13819646, matrix, (MultiBufferSource)source, 0xF000F0);
        this.drawExperienceFluid(graphics, (float)(currentLevel / (double)maxLevel));
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 118, this.topPos + 22, 32, 48)) {
            this.setTooltipForNextRenderPass((Component)Utils.translation("gui", "experience_points", (int)this.getExperiencePoints()));
        }
    }

    private double getExperiencePoints() {
        return (double)((RecycleBinMenu)this.menu).getRecycledCount() * (Double)Config.SERVER.recycleBin.experiencePerItem.get();
    }

    private double getExperienceLevel() {
        double points = this.getExperiencePoints();
        if (points <= 352.0) {
            return Math.sqrt(points + 9.0) - 3.0;
        }
        if (points <= 1507.0) {
            return 8.1 + Math.sqrt(0.4 * (points - 195.975));
        }
        return 18.055555555555557 + Math.sqrt(0.2222222222222222 * (points - 752.9861111111111));
    }

    private void drawExperienceFluid(GuiGraphics graphics, float amount) {
        int yOffset = 48 - (int)(48.0f * amount);
        int height = (int)(48.0f * amount);
        float animation = (Mth.sin((float)((float)Util.getMillis() / 500.0f)) + 1.0f) / 2.0f;
        this.drawBlitWithAlpha(graphics, this.leftPos + 118, this.topPos + 22 + yOffset, 176, 17, 32, height, animation);
        this.drawBlitWithAlpha(graphics, this.leftPos + 118, this.topPos + 22 + yOffset, 208, 17, 32, height, 1.0f - animation);
    }

    private void drawBlitWithAlpha(GuiGraphics graphics, int x, int y, int u, int v, int width, int height, float alpha) {
        float scale = 0.00390625f;
        RenderType type = RenderType.guiTextured((ResourceLocation)RECYCLING_BIN_TEXTURE);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv((float)u * scale, (float)v * scale).setColor(1.0f, 1.0f, 1.0f, alpha);
        builder.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setUv((float)u * scale, (float)(v + height) * scale).setColor(1.0f, 1.0f, 1.0f, alpha);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setUv((float)(u + width) * scale, (float)(v + height) * scale).setColor(1.0f, 1.0f, 1.0f, alpha);
        builder.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setUv((float)(u + width) * scale, (float)v * scale).setColor(1.0f, 1.0f, 1.0f, alpha);
        try (MeshData data = builder.build();){
            if (data != null) {
                type.draw(data);
            }
        }
    }
}

