/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.core.ModExtraModels;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ElectricBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final Set<Connection> DRAWN_CONNECTIONS = new HashSet<Connection>();
    private static final int DEFAULT_COLOUR = -1;
    private static final int POWERED_COLOUR = -9652;
    private static final int CROSSING_ZONE_COLOUR = -3983818;
    private static final float POWER_NODE_SCALE = 1.5f;

    public ElectricBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T node, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay, Vec3 camera) {
        ElectricBlockEntityRenderer.drawNodeAndConnections((IElectricityNode)node);
    }

    public static void drawNodeAndConnections(IElectricityNode node) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || !LinkHandler.isHoldingWrench()) {
            return;
        }
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        LinkHandler handler = LinkHandler.get();
        boolean isLookingAt = handler.isTargetNode(node);
        if (isLookingAt && !handler.isLinking() && !node.isNodeConnectionLimitReached() || handler.isLinkingNode(node) || handler.canLinkToNode(node.getNodeLevel(), node) && handler.isTargetNode(node)) {
            AABB box = node.getNodeInteractBox();
            int color = handler.getLinkColour(node.getNodeLevel());
            renderer.deferDraw((pose, consumer) -> {
                pose.pushPose();
                BlockPos pos = node.getNodePosition();
                pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                Matrix4f matrix = pose.last().pose();
                renderer.drawInvertedColouredBox(matrix, (VertexConsumer)consumer, box.inflate(0.03125), color, 0.7f);
                pose.popPose();
            });
        }
        for (Connection connection : node.getNodeConnections()) {
            if (DRAWN_CONNECTIONS.contains(connection)) continue;
            DRAWN_CONNECTIONS.add(connection);
            renderer.deferDraw((pose, consumer) -> {
                pose.pushPose();
                BlockPos pos = node.getNodePosition();
                pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                pose.translate(0.5, 0.5, 0.5);
                Vec3 delta = Vec3.atLowerCornerOf((Vec3i)connection.getPosB().subtract((Vec3i)connection.getPosA()));
                double yaw = Math.atan2(-delta.z, delta.x) + Math.PI;
                double pitch = Math.atan2(delta.horizontalDistance(), delta.y) + 1.5707963705062866;
                boolean selected = !handler.isLinking() && connection.equals(handler.getTargetConnection());
                int color = ElectricBlockEntityRenderer.getConnectionColour(connection, node.getNodeLevel());
                float offset = (float)(Math.sin((double)Util.getMillis() / 500.0) + 1.0) / 2.0f * 0.2f;
                AABB box = new AABB(0.0, -0.03125, -0.03125, delta.length(), 0.03125, 0.03125);
                pose.mulPose((Quaternionfc)Axis.YP.rotation((float)yaw));
                pose.mulPose((Quaternionfc)Axis.ZP.rotation((float)pitch));
                Matrix4f matrix = pose.last().pose();
                renderer.drawColouredBox(matrix, (VertexConsumer)consumer, box, color, 0.7f + offset);
                renderer.drawColouredBox(matrix, (VertexConsumer)consumer, box.inflate(0.03125), color, 0.5f + offset);
                if (selected) {
                    renderer.drawColouredBox(matrix, (VertexConsumer)consumer, box.inflate(0.03125), -1, 0.8f);
                }
                pose.popPose();
            });
        }
        renderer.deferDraw((pose, consumer) -> {
            pose.pushPose();
            BlockPos pos = node.getNodePosition();
            pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            Matrix4f matrix = pose.last().pose();
            renderer.drawTexturedBox(matrix, (VertexConsumer)consumer, node.getNodeInteractBox(), 0.0f, 0.0f, 0.25f, 0.25f);
            pose.popPose();
        });
    }

    private static int getConnectionColour(Connection connection, Level level) {
        if (connection.isCrossingPowerableZone(level)) {
            return -3983818;
        }
        if (connection.isPowered(level)) {
            return -9652;
        }
        return -1;
    }

    private static BlockModelPart getNodeModel(IElectricityNode node) {
        if (node.isNodeConnectionLimitReached()) {
            return (BlockModelPart)ModExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        LinkHandler handler = LinkHandler.get();
        if (handler.isLinking() && !handler.isLinkingNode(node)) {
            if (handler.canLinkToNode(node.getNodeLevel(), node)) {
                return (BlockModelPart)ModExtraModels.ELECTRIC_NODE_SUCCESS.getModel();
            }
            return (BlockModelPart)ModExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        if (node.isNodePowered()) {
            return (BlockModelPart)ModExtraModels.ELECTRIC_NODE_NEUTRAL.getModel();
        }
        return (BlockModelPart)ModExtraModels.ELECTRIC_NODE_POWER.getModel();
    }

    public boolean shouldRenderOffScreen(T node) {
        return true;
    }

    public int getViewDistance() {
        return (Integer)Config.CLIENT.electricityViewDistance.get();
    }

    public AABB getRenderBoundingBox(T node) {
        return new AABB(((IElectricityNode)node).getNodePosition()).inflate((double)((Integer)Config.CLIENT.electricityViewDistance.get()).intValue());
    }

    public static void clearDrawn() {
        DRAWN_CONNECTIONS.clear();
    }

    public static Set<Connection> getDrawnConnections() {
        return DRAWN_CONNECTIONS;
    }
}

