/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public record StackedIngredient(Ingredient ingredient, int count) {
    public static final Codec<StackedIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(o -> o.ingredient), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(o -> o.count)).apply((Applicative)builder, StackedIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StackedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, StackedIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, StackedIngredient::count, StackedIngredient::new);

    public static StackedIngredient of(HolderSet<Item> items, int count) {
        return new StackedIngredient(Ingredient.of(items), count);
    }

    public static StackedIngredient of(ItemStack stack) {
        return new StackedIngredient(Ingredient.of((ItemLike)stack.getItem()), stack.getCount());
    }

    public static StackedIngredient of(Ingredient ingredient, int count) {
        return new StackedIngredient(ingredient, count);
    }
}

