/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.ClientMailbox;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DeliveryService
extends SavedData {
    private static final SavedDataType<DeliveryService> TYPE = new SavedDataType("refurbished_furniture_delivery_service", context -> new DeliveryService(context.levelOrThrow().getServer()), context -> CompoundTag.CODEC.xmap(tag -> {
        ServerLevel level = context.levelOrThrow();
        MinecraftServer server = level.getServer();
        RegistryAccess access = level.registryAccess();
        return new DeliveryService(server, (CompoundTag)tag, (HolderLookup.Provider)access);
    }, service -> {
        ServerLevel level = context.levelOrThrow();
        RegistryAccess access = level.registryAccess();
        return service.save((HolderLookup.Provider)access);
    }), null);
    private final MinecraftServer server;
    private final Map<Pair<ResourceLocation, BlockPos>, Mailbox> locator = new HashMap<Pair<ResourceLocation, BlockPos>, Mailbox>();
    private final Map<UUID, Mailbox> mailboxes = new ConcurrentHashMap<UUID, Mailbox>();
    private final Queue<Mailbox> removal = new ArrayDeque<Mailbox>();
    private final Map<UUID, Pair<ResourceLocation, BlockPos>> pendingNames = new HashMap<UUID, Pair<ResourceLocation, BlockPos>>();

    public static Optional<DeliveryService> get(MinecraftServer server) {
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level != null) {
            return Optional.of((DeliveryService)level.getDataStorage().computeIfAbsent(TYPE));
        }
        return Optional.empty();
    }

    public DeliveryService(MinecraftServer server) {
        this.server = server;
    }

    public DeliveryService(MinecraftServer server, CompoundTag compound, HolderLookup.Provider provider) {
        this.server = server;
        this.load(compound, provider);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void serverTick() {
        while (!this.removal.isEmpty()) {
            Mailbox mailbox2 = this.removal.poll();
            mailbox2.spawnQueueIntoLevel();
            this.mailboxes.remove(mailbox2.id());
            this.locator.remove(Pair.of((Object)mailbox2.levelKey().location(), (Object)mailbox2.pos()));
            this.setDirty();
        }
        this.mailboxes.forEach((uuid, mailbox) -> mailbox.tick());
    }

    public DeliveryResult sendMail(UUID id, ItemStack stack) {
        Mailbox mailbox = this.mailboxes.get(id);
        if (mailbox == null) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.unknown_mailbox"));
        }
        if (mailbox.queue().size() >= (Integer)Config.SERVER.mailing.deliveryQueueSize.get()) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.mailbox_queue_full"));
        }
        if (!DeliveryService.isDeliverableDimension(mailbox.levelKey())) {
            return DeliveryResult.createFail(Utils.translationKey("gui", "delivery_service.undeliverable_dimension"));
        }
        mailbox.queue().offer(stack);
        this.setDirty();
        return DeliveryResult.createSuccess(Utils.translationKey("gui", "delivery_service.package_sent"));
    }

    void removeMailbox(Mailbox mailbox) {
        this.removal.offer(mailbox);
    }

    public boolean canCreateMailbox(Player player) {
        long count = this.mailboxes.values().stream().filter(box -> player.getUUID().equals(box.owner().getValue())).count();
        return (long)((Integer)Config.SERVER.mailing.maxMailboxesPerPlayer.get()).intValue() > count;
    }

    public Mailbox getOrCreateMailBox(MailboxBlockEntity blockEntity) {
        this.duplicateIdCheck(blockEntity);
        return this.mailboxes.computeIfAbsent(blockEntity.getId(), uuid -> {
            ResourceKey levelKey = blockEntity.getLevel().dimension();
            BlockPos pos = blockEntity.getBlockPos();
            Mailbox mailbox = new Mailbox((UUID)uuid, (ResourceKey<Level>)levelKey, pos, (MutableObject<UUID>)new MutableObject(), (MutableObject<String>)new MutableObject((Object)""), (Queue<ItemStack>)new ArrayDeque<ItemStack>(), new MutableBoolean(), this);
            this.locator.put((Pair<ResourceLocation, BlockPos>)Pair.of((Object)levelKey.location(), (Object)pos), mailbox);
            this.setDirty();
            return mailbox;
        });
    }

    private void duplicateIdCheck(MailboxBlockEntity blockEntity) {
        Mailbox box = this.mailboxes.get(blockEntity.getId());
        if (box != null && !box.pos().equals((Object)blockEntity.getBlockPos())) {
            blockEntity.regenerateId();
        }
    }

    public Optional<Mailbox> getMailboxAtPosition(Level level, BlockPos pos) {
        return Optional.ofNullable(this.locator.get(Pair.of((Object)level.dimension().location(), (Object)pos)));
    }

    public void markMailboxAsPendingName(Player player, Level level, BlockPos pos) {
        this.pendingNames.put(player.getUUID(), (Pair<ResourceLocation, BlockPos>)Pair.of((Object)level.dimension().location(), (Object)pos));
    }

    public boolean renameMailbox(Player player, Level level, BlockPos pos, String customName) {
        Pair<ResourceLocation, BlockPos> pendingLocation = this.pendingNames.remove(player.getUUID());
        return this.getMailboxAtPosition(level, pos).map(mailbox -> {
            if (!Objects.equals(mailbox.owner().getValue(), player.getUUID())) {
                return false;
            }
            Pair location = Pair.of((Object)level.dimension().location(), (Object)pos);
            return Objects.equals(location, pendingLocation) && mailbox.rename(customName);
        }).orElse(false);
    }

    public Collection<IMailbox> getMailboxes() {
        return Collections.unmodifiableCollection(this.mailboxes.values());
    }

    public void encodeMailboxes(FriendlyByteBuf buf) {
        buf.writeCollection(this.mailboxes.values(), (buf1, mailbox) -> {
            buf1.writeUUID(mailbox.getId());
            buf1.writeOptional(mailbox.getOwner(), (buf2, profile) -> {
                buf2.writeUUID(profile.getId());
                buf2.writeOptional(Optional.ofNullable(profile.getName()), FriendlyByteBuf::writeUtf);
            });
            buf1.writeOptional(mailbox.getCustomName(), FriendlyByteBuf::writeUtf);
        });
    }

    public static List<IMailbox> decodeMailboxes(FriendlyByteBuf buf) {
        List list = buf.readList(buf1 -> {
            UUID mailboxId = buf1.readUUID();
            Optional profile = buf1.readOptional(buf2 -> {
                UUID playerId = buf2.readUUID();
                Optional name = buf2.readOptional(FriendlyByteBuf::readUtf);
                return new GameProfile(playerId, name.orElse("Unknown"));
            });
            Optional mailboxName = buf1.readOptional(FriendlyByteBuf::readUtf);
            return new ClientMailbox(mailboxId, profile, mailboxName);
        });
        return ImmutableList.copyOf((Collection)list);
    }

    private void load(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Mailboxes")) {
            ListTag list = compound.getListOrEmpty("Mailboxes");
            list.forEach(tag -> {
                if (!(tag instanceof CompoundTag)) {
                    return;
                }
                CompoundTag mailboxTag = (CompoundTag)tag;
                try {
                    ResourceKey<Level> levelKey = DeliveryService.createLevelKey((String)mailboxTag.getString("Level").orElseThrow());
                    UUID id = (UUID)mailboxTag.read("UUID", UUIDUtil.CODEC).orElseThrow();
                    BlockPos pos = BlockPos.of((long)((Long)mailboxTag.getLong("BlockPosition").orElseThrow()));
                    MutableObject owner = new MutableObject();
                    if (mailboxTag.contains("Owner")) {
                        mailboxTag.read("Owner", UUIDUtil.CODEC).ifPresent(arg_0 -> ((MutableObject)owner).setValue(arg_0));
                    }
                    String customName = mailboxTag.getString("CustomName").orElse("Mailbox");
                    customName = customName.substring(0, Math.min(customName.length(), 32));
                    Queue<ItemStack> queue = Mailbox.readQueueListTag(mailboxTag, provider);
                    Mailbox mailbox = new Mailbox(id, levelKey, pos, (MutableObject<UUID>)owner, (MutableObject<String>)new MutableObject((Object)customName), queue, new MutableBoolean(), this);
                    this.mailboxes.putIfAbsent(id, mailbox);
                    this.locator.put((Pair<ResourceLocation, BlockPos>)Pair.of((Object)levelKey.location(), (Object)pos), mailbox);
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load a mailbox due to invalid data");
                }
            });
        }
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.mailboxes.forEach((uuid, mailbox) -> {
            if (!mailbox.removed().booleanValue()) {
                CompoundTag mailboxTag = new CompoundTag();
                mailboxTag.store("UUID", UUIDUtil.CODEC, uuid);
                mailboxTag.putString("Level", mailbox.levelKey().location().toString());
                mailboxTag.putLong("BlockPosition", mailbox.pos().asLong());
                Optional.ofNullable((UUID)mailbox.owner().getValue()).ifPresent(id -> mailboxTag.store("Owner", UUIDUtil.CODEC, id));
                Optional.ofNullable((String)mailbox.customName().getValue()).ifPresent(name -> mailboxTag.putString("CustomName", name));
                mailbox.writeQueue(mailboxTag, provider);
                list.add((Object)mailboxTag);
            }
        });
        tag.put("Mailboxes", (Tag)list);
        return tag;
    }

    @Nullable
    private static ResourceKey<Level> createLevelKey(String levelKey) {
        ResourceKey resourceKey;
        if (levelKey.isBlank()) {
            resourceKey = null;
        } else {
            switch (levelKey) {
                case "minecraft:overworld": {
                    resourceKey = Level.OVERWORLD;
                    break;
                }
                case "minecraft:the_nether": {
                    resourceKey = Level.NETHER;
                    break;
                }
                case "minecraft:the_end": {
                    resourceKey = Level.END;
                    break;
                }
                default: {
                    resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)levelKey));
                }
            }
        }
        return resourceKey;
    }

    public static boolean isBannedItem(ItemStack stack) {
        if (((Boolean)Config.SERVER.mailing.banSendingItemsWithInventories.get()).booleanValue() && !stack.getItem().canFitInsideContainerItems()) {
            return true;
        }
        String name = stack.getItem().getDescriptionId();
        return ((List)Config.SERVER.mailing.bannedItems.get()).contains(name);
    }

    public static boolean isDeliverableDimension(Level level) {
        return DeliveryService.isDeliverableDimension((ResourceKey<Level>)level.dimension());
    }

    public static boolean isDeliverableDimension(ResourceKey<Level> key) {
        List validDimensions = (List)Config.SERVER.mailing.allowedDimensions.get();
        if (!validDimensions.isEmpty()) {
            return validDimensions.contains(key.location().toString());
        }
        return true;
    }
}

