/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import org.jetbrains.annotations.Nullable;

public class BlockEntityHelper {
    public static void sendCustomUpdate(BlockEntity entity, BiFunction<BlockEntity, RegistryAccess, CompoundTag> update) {
        ChunkSource chunkSource;
        Level level = entity.getLevel();
        if (level != null && (chunkSource = level.getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = entity.getBlockPos();
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)entity, update);
            List players = cache.chunkMap.getPlayers(new ChunkPos(pos), false);
            players.forEach(player -> player.connection.send((Packet)packet));
        }
    }

    public static void saveItems(String key, CompoundTag tag, NonNullList<ItemStack> items, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag slot = new CompoundTag();
            slot.putByte("Slot", (byte)i);
            list.add((Object)stack.save(provider, (Tag)slot));
        }
        tag.put(key, (Tag)list);
    }

    public static void loadItems(String key, HolderLookup.Provider provider, CompoundTag tag, NonNullList<ItemStack> items) {
        items.clear();
        tag.getList(key).ifPresent(list -> list.forEach(nbt -> {
            if (nbt instanceof CompoundTag) {
                CompoundTag slot = (CompoundTag)nbt;
                slot.getByte("Slot").ifPresent(index -> {
                    if (index >= 0 && index < items.size()) {
                        items.set((int)index.byteValue(), (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)slot).orElse(ItemStack.EMPTY));
                    }
                });
            }
        }));
    }

    public static NonNullList<ItemStack> nonNullListFromContainer(Container container) {
        int size = container.getContainerSize();
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int i = 0; i < size; ++i) {
            items.set(i, (Object)container.getItem(i));
        }
        return items;
    }

    public static void saveCustomName(CompoundTag tag, @Nullable Component component, HolderLookup.Provider provider) {
        if (component != null) {
            tag.put("CustomName", (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)component).getOrThrow());
        }
    }
}

