/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWithdrawExperience;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.text.DecimalFormat;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class RecyclingBinScreen
extends ElectricityContainerScreen<RecycleBinMenu> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.###");
    private static final class_2960 RECYCLING_BIN_TEXTURE = Utils.resource("textures/gui/container/recycle_bin.png");
    private OnOffSlider slider;
    private class_4185 withdrawButton;

    public RecyclingBinScreen(RecycleBinMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.field_2779 = 193;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.slider = (OnOffSlider)this.method_37063((class_364)new OnOffSlider(this.field_2776 + this.field_2792 - 22 - 6, this.field_2800 + 5, Components.GUI_TOGGLE_POWER, btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
        this.withdrawButton = (class_4185)this.method_37063((class_364)new IconButton(this.field_2776 + 7, this.field_2800 + 75, 20, 10, 162, Components.GUI_WITHDRAW_EXPERIENCE, btn -> Network.getPlay().sendToServer((Object)new MessageWithdrawExperience())));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((RecycleBinMenu)this.field_2797).isEnabled());
        this.withdrawButton.field_22763 = this.getExperiencePoints() >= 1.0;
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.method_2380(graphics, mouseX, mouseY);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTick, int mouseX, int mouseY) {
        super.method_2389(graphics, partialTick, mouseX, mouseY);
        graphics.method_25290(class_1921::method_62277, RECYCLING_BIN_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        if (((RecycleBinMenu)this.field_2797).getProcessTime() >= 0) {
            int maxProcessTime = (Integer)Config.SERVER.recycleBin.processingTime.get();
            int width = (int)Math.ceil(25.0f * ((float)((RecycleBinMenu)this.field_2797).getProcessTime() / (float)maxProcessTime));
            graphics.method_25290(class_1921::method_62277, RECYCLING_BIN_TEXTURE, this.field_2776 + 85, this.field_2800 + 28, 176.0f, 0.0f, width, 17, 256, 256);
        }
        int maxLevel = (Integer)Config.SERVER.recycleBin.maximumExperienceLevels.get();
        double currentLevel = class_3532.method_15350((double)this.getExperienceLevel(), (double)0.0, (double)maxLevel);
        class_5250 levelLabel = Utils.translation("gui", "experience_level", FORMAT.format(currentLevel), maxLevel);
        int labelWidth = this.field_22787.field_1772.method_27525((class_5348)levelLabel) / 2;
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_4597.class_4598 source = this.field_22787.method_22940().method_23000();
        this.field_22787.field_1772.method_37296(levelLabel.method_30937(), (float)(this.field_2776 + 68 - labelWidth), (float)(this.field_2800 + 60), -3604593, -13819646, matrix, (class_4597)source, 0xF000F0);
        this.drawExperienceFluid(graphics, (float)(currentLevel / (double)maxLevel));
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 118, this.field_2800 + 22, 32, 48)) {
            this.method_47415((class_2561)Utils.translation("gui", "experience_points", (int)this.getExperiencePoints()));
        }
    }

    private double getExperiencePoints() {
        return (double)((RecycleBinMenu)this.field_2797).getRecycledCount() * (Double)Config.SERVER.recycleBin.experiencePerItem.get();
    }

    private double getExperienceLevel() {
        double points = this.getExperiencePoints();
        if (points <= 352.0) {
            return Math.sqrt(points + 9.0) - 3.0;
        }
        if (points <= 1507.0) {
            return 8.1 + Math.sqrt(0.4 * (points - 195.975));
        }
        return 18.055555555555557 + Math.sqrt(0.2222222222222222 * (points - 752.9861111111111));
    }

    private void drawExperienceFluid(class_332 graphics, float amount) {
        int yOffset = 48 - (int)(48.0f * amount);
        int height = (int)(48.0f * amount);
        float animation = (class_3532.method_15374((float)((float)class_156.method_658() / 500.0f)) + 1.0f) / 2.0f;
        this.drawBlitWithAlpha(graphics, this.field_2776 + 118, this.field_2800 + 22 + yOffset, 176, 17, 32, height, animation);
        this.drawBlitWithAlpha(graphics, this.field_2776 + 118, this.field_2800 + 22 + yOffset, 208, 17, 32, height, 1.0f - animation);
    }

    private void drawBlitWithAlpha(class_332 graphics, int x, int y, int u, int v, int width, int height, float alpha) {
        float scale = 0.00390625f;
        class_1921 type = class_1921.method_62277((class_2960)RECYCLING_BIN_TEXTURE);
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913((float)u * scale, (float)v * scale).method_22915(1.0f, 1.0f, 1.0f, alpha);
        builder.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_22913((float)u * scale, (float)(v + height) * scale).method_22915(1.0f, 1.0f, 1.0f, alpha);
        builder.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_22913((float)(u + width) * scale, (float)(v + height) * scale).method_22915(1.0f, 1.0f, 1.0f, alpha);
        builder.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_22913((float)(u + width) * scale, (float)v * scale).method_22915(1.0f, 1.0f, 1.0f, alpha);
        try (class_9801 data = builder.method_60794();){
            if (data != null) {
                type.method_60895(data);
            }
        }
    }
}

