/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BathBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BathBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    protected static final VoxelShape BASE_SHAPE = Block.box((double)0.0, (double)2.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
    protected static final VoxelShape COLLISION_SHAPE = Shapes.join((VoxelShape)BASE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)4.0, (double)2.0, (double)28.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);

    public BathBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.BOTTOM)));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            if (state.getValue(TYPE) == Type.HEAD) {
                return VoxelShapeHelper.rotateHorizontally(BASE_SHAPE.move(-1.0, 0.0, 0.0), (Direction)state.getValue((Property)DIRECTION));
            }
            return VoxelShapeHelper.rotateHorizontally(BASE_SHAPE, (Direction)state.getValue((Property)DIRECTION));
        })));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (state.getValue(TYPE) == Type.HEAD) {
            return VoxelShapeHelper.rotateHorizontally(COLLISION_SHAPE.move(-1.0, 0.0, 0.0), (Direction)state.getValue((Property)DIRECTION));
        }
        return VoxelShapeHelper.rotateHorizontally(COLLISION_SHAPE, (Direction)state.getValue((Property)DIRECTION));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos headPos;
        Direction direction = context.getHorizontalDirection();
        Level level = context.getLevel();
        if (level.getBlockState(headPos = context.getClickedPos().relative(direction)).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(headPos)) {
            return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)direction);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide()) {
            BlockPos headPos = pos.relative((Direction)state.getValue((Property)DIRECTION));
            level.setBlock(headPos, (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.HEAD)), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!state.is(newState.getBlock())) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            Type type = (Type)((Object)state.getValue(TYPE));
            BlockPos otherPos = pos.relative(type == Type.HEAD ? direction.getOpposite() : direction);
            BlockState otherState = level.getBlockState(otherPos);
            if (otherState.getBlock() instanceof BathBlock && otherState.getValue(TYPE) != type) {
                level.removeBlock(otherPos, false);
            }
        }
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)blockEntity;
            return bath.interact(player, hand, result);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BathBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return BathBlock.createTicker(type, (BlockEntityType)ModBlockEntities.BATH.get(), BathBlockEntity::clientTick);
        }
        return null;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource source) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)blockEntity;
            FluidContainer container = bath.getFluidContainer();
            if (container == null || container.isEmpty()) {
                return;
            }
            double fullness = (double)container.getStoredAmount() / (double)container.getCapacity();
            if (fullness < 0.6) {
                return;
            }
            container.getStoredFluid().defaultFluidState().animateTick(level, pos, source);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)blockEntity;
            FluidContainer container = bath.getFluidContainer();
            if (container == null || container.isEmpty()) {
                return;
            }
            double fullness = (double)container.getStoredAmount() / (double)container.getCapacity();
            double startY = (double)pos.getY() + 0.25;
            double endY = (double)pos.getY() + 0.9375 * fullness;
            if (entity.getY() < startY || entity.getY() > endY) {
                return;
            }
            if (container.getStoredFluid().isSame((Fluid)Fluids.LAVA)) {
                entity.lavaHurt();
            } else if (container.getStoredFluid().isSame((Fluid)Fluids.WATER)) {
                if (!entity.isSilent() && entity.isOnFire()) {
                    float volume = 0.7f;
                    float pitch = 1.6f + 0.4f * (level.random.nextFloat() - level.random.nextFloat());
                    level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GENERIC_EXTINGUISH_FIRE, entity.getSoundSource(), volume, pitch);
                }
                entity.clearFire();
            }
        }
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    public static enum Type implements StringRepresentable
    {
        HEAD("head"),
        BOTTOM("bottom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

