/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GrillBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<GrillBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyeColor.CODEC.fieldOf("color").forGetter(block -> block.color), (App)GrillBlock.propertiesCodec()).apply((Applicative)builder, GrillBlock::new));
    private final DyeColor color;

    public GrillBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.color = color;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    protected MapCodec<GrillBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> baseShape)));
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof GrillBlockEntity) {
                GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, grill.getCookingItems());
                Containers.dropContents((Level)level, (BlockPos)pos, grill.getFuelItems());
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && result.getDirection() == Direction.UP && (blockEntity = level.getBlockEntity(pos)) instanceof GrillBlockEntity) {
            GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
            if (stack.getItem() == ModItems.SPATULA.get()) {
                grill.flipItem(this.getGrillQuadrant(result));
                FryingPanBlock.playSpatulaScoopSound(level, pos.above(), 0.0);
            } else if (grill.addFuel(stack)) {
                stack.shrink(1);
                level.playSound(null, pos, SoundEvents.ANCIENT_DEBRIS_HIT, SoundSource.BLOCKS, 1.0f, 1.5f);
            } else if (!stack.isEmpty()) {
                if (grill.addCookingItem(stack, this.getGrillQuadrant(result), player.getDirection().get2DDataValue()) && !player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            } else {
                grill.removeCookingItem(this.getGrillQuadrant(result));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getGrillQuadrant(BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        Vec3 hitVec = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return (hitVec.x() > 0.5 ? 1 : 0) + (hitVec.z() > 0.5 ? 2 : 0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrillBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide()) {
            return GrillBlock.createTicker(type, (BlockEntityType)ModBlockEntities.GRILL.get(), GrillBlockEntity::clientTick);
        }
        return GrillBlock.createTicker(type, (BlockEntityType)ModBlockEntities.GRILL.get(), GrillBlockEntity::serverTick);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_STONE_TOOL);
    }
}

