/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.LeafType;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class HedgeBlock
extends CrossCollisionBlock
implements BlockTagSupplier {
    private static final MapCodec<HedgeBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)LeafType.CODEC.fieldOf("leaf_type").forGetter(block -> block.type), (App)HedgeBlock.propertiesCodec()).apply((Applicative)builder, HedgeBlock::new));
    private final LeafType type;

    public HedgeBlock(LeafType type, BlockBehaviour.Properties properties) {
        super(4.0f, 4.0f, 16.0f, 16.0f, 24.0f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public LeafType getLeafType() {
        return this.type;
    }

    protected MapCodec<HedgeBlock> codec() {
        return CODEC;
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos p_60546_, BlockState p_60543_, RandomSource p_374120_) {
        if (direction.getAxis().isHorizontal()) {
            return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectToFace(reader, pos, direction)));
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level reader = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluid = reader.getFluidState(pos);
        boolean north = this.canConnectToFace((LevelReader)reader, pos, Direction.NORTH);
        boolean east = this.canConnectToFace((LevelReader)reader, pos, Direction.EAST);
        boolean south = this.canConnectToFace((LevelReader)reader, pos, Direction.SOUTH);
        boolean west = this.canConnectToFace((LevelReader)reader, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    private boolean canConnectToFace(LevelReader reader, BlockPos pos, Direction direction) {
        BlockState state = reader.getBlockState(pos = pos.relative(direction));
        return !HedgeBlock.isExceptionForConnection((BlockState)state) && state.isFaceSturdy((BlockGetter)reader, pos, direction.getOpposite()) || state.getBlock() instanceof HedgeBlock || state.getBlock() instanceof LeavesBlock;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Deprecated
    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_HOE);
    }
}

