/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.FurnitureBlock;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrampolineBlock
extends FurnitureBlock
implements BlockTagSupplier {
    private static final MapCodec<TrampolineBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyeColor.CODEC.fieldOf("color").forGetter(block -> block.color), (App)TrampolineBlock.propertiesCodec()).apply((Applicative)builder, TrampolineBlock::new));
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    private final DyeColor color;

    public TrampolineBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    protected MapCodec<TrampolineBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
        VoxelShape bottomLeftSupportShortShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)15.0);
        VoxelShape bottomLeftSupportLongShape = Block.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)16.0);
        VoxelShape bottomLeftSupportNorthShape = Block.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)15.0);
        VoxelShape bottomLeftSupportSouthShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)16.0);
        VoxelShape backLeftLegShape = Block.box((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)10.0, (double)3.0);
        VoxelShape frontLeftLegShape = Block.box((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)10.0, (double)15.0);
        VoxelShape bottomRightSupportShortShape = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape bottomRightSupportLongShape = Block.box((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
        VoxelShape bottomRightSupportNorthShape = Block.box((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape bottomRightSupportSouthShape = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)16.0);
        VoxelShape frontRightLegShape = Block.box((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)10.0, (double)15.0);
        VoxelShape backRightLegShape = Block.box((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0);
        VoxelShape northWestCornerSupportShape = Block.box((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)3.0);
        VoxelShape northEastCornerSupportShape = Block.box((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)3.0);
        VoxelShape southEastCornerSupportShape = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)2.0, (double)16.0);
        VoxelShape southWestCornerSupportShape = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> topShape)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapes.get(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getTrampolineState(this.defaultBlockState(), (LevelReader)context.getLevel(), context.getClickedPos());
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos p_60546_, BlockState p_60543_, RandomSource p_374120_) {
        return this.getTrampolineState(state, reader, pos);
    }

    private BlockState getTrampolineState(BlockState state, LevelReader reader, BlockPos pos) {
        boolean connectedNorth = this.isTrampoline(reader, pos.north());
        boolean connectedEast = this.isTrampoline(reader, pos.east());
        boolean connectedSouth = this.isTrampoline(reader, pos.south());
        boolean connectedWest = this.isTrampoline(reader, pos.west());
        boolean legNorthWest = connectedNorth && connectedWest && !this.isTrampoline(reader, pos.north().west());
        boolean legNorthEast = connectedNorth && connectedEast && !this.isTrampoline(reader, pos.north().east());
        boolean legSouthEast = connectedSouth && connectedEast && !this.isTrampoline(reader, pos.south().east());
        boolean legSouthWest = connectedSouth && connectedWest && !this.isTrampoline(reader, pos.south().west());
        int packedValue = Shape.createPackedValue(connectedNorth, connectedEast, connectedSouth, connectedWest, legNorthWest, legNorthEast, legSouthEast, legSouthWest);
        Shape shape = Shape.fromPackedValue(packedValue);
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
    }

    private boolean isTrampoline(LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos).getBlock() instanceof TrampolineBlock;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
    }

    public void applyPhysics(BlockPos pos, BlockState state, Entity entity, float fallPower) {
        if (entity.isSuppressingBounce()) {
            return;
        }
        float bounceForce = 2.0f;
        float maxBounceHeight = ((Double)Config.SERVER.trampoline.maxBounceHeight.get()).floatValue() * ((Shape)((Object)state.getValue(TrampolineBlock.SHAPE))).bounceScale * 0.75f;
        float bounceHeight = Math.min(fallPower * bounceForce, maxBounceHeight - 0.25f);
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.5, 0.0, 1.5));
        entity.push(0.0, Math.sqrt(0.22 * (double)(bounceHeight + 0.25f)), 0.0);
        Level level = entity.level();
        this.spawnBounceParticle(level, entity, pos, !(entity instanceof Player));
        if (!level.isClientSide()) {
            level.playSound(null, pos, (SoundEvent)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
        } else if (entity.isControlledByOrIsLocalPlayer()) {
            level.playSound((Entity)entity.getControllingPassenger(), pos, (SoundEvent)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
        }
    }

    public void updateEntityMovementAfterFallOn(BlockGetter getter, Entity entity) {
        Vec3 movement = entity.getDeltaMovement();
        if (movement.y < 0.0) {
            super.updateEntityMovementAfterFallOn(getter, entity);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SHAPE});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.NEEDS_STONE_TOOL);
    }

    public float getJumpModifier(Level level, BlockState state, BlockPos pos) {
        Shape shape = (Shape)((Object)state.getValue(SHAPE));
        float bounceHeight = ((Double)Config.SERVER.trampoline.maxBounceHeight.get()).floatValue() * shape.bounceScale;
        return Mth.sqrt((float)(0.22f * bounceHeight)) * 2.3f;
    }

    public void onLivingEntityJump(LivingEntity entity, Level level, BlockState state, BlockPos pos) {
        if (level.isClientSide()) {
            level.playLocalSound(pos, (SoundEvent)ModSounds.BLOCK_TRAMPOLINE_SUPER_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.75f, false);
            this.spawnBounceParticle(level, (Entity)entity, pos, true);
        }
    }

    private void spawnBounceParticle(Level level, Entity bouncingEntity, BlockPos pos, boolean superBounce) {
        if (!level.isClientSide()) {
            if (!(bouncingEntity instanceof Player)) {
                ParticleOptions particle = superBounce ? (ParticleOptions)ModParticleTypes.SUPER_BOUNCE.get() : (ParticleOptions)ModParticleTypes.BOUNCE.get();
                Vec3 particlePos = Vec3.upFromBottomCenterOf((Vec3i)pos, (double)0.82);
                ((ServerLevel)level).sendParticles(particle, bouncingEntity.xo, particlePos.y, bouncingEntity.zo, 0, 0.0, 0.0, 0.0, 0.0);
            }
            return;
        }
        ParticleOptions particle = superBounce ? (ParticleOptions)ModParticleTypes.SUPER_BOUNCE.get() : (ParticleOptions)ModParticleTypes.BOUNCE.get();
        Vec3 particlePos = Vec3.upFromBottomCenterOf((Vec3i)pos, (double)0.82);
        level.addParticle(particle, bouncingEntity.xo, particlePos.y, bouncingEntity.zo, 0.0, 0.0, 0.0);
    }

    private void bounceBoat(Boat boat, Vec3 velocity) {
        Level level = boat.level();
        boat.setDeltaMovement(velocity.x, -velocity.y, velocity.z);
        if (boat.isControlledByLocalInstance() && !boat.isEffectiveAi()) {
            level.playLocalSound(boat.blockPosition(), (SoundEvent)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.9f, false);
        } else {
            level.playSound(null, boat.blockPosition(), (SoundEvent)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
        }
    }

    public static enum Shape implements StringRepresentable
    {
        DEFAULT("default", 0.4f),
        NORTH("north", 0.4f),
        EAST("east", 0.4f),
        SOUTH("south", 0.4f),
        WEST("west", 0.4f),
        NORTH_SOUTH("north_south", 0.4f),
        EAST_WEST("east_west", 0.4f),
        NORTH_EAST("north_east", 0.8f),
        EAST_SOUTH("east_south", 0.8f),
        SOUTH_WEST("south_west", 0.8f),
        WEST_NORTH("west_north", 0.8f),
        NORTH_EAST_WITH_LEG("north_east_with_leg_northeast", 0.4f),
        EAST_SOUTH_WITH_LEG("east_south_with_leg_eastsouth", 0.4f),
        SOUTH_WEST_WITH_LEG("south_west_with_leg_southwest", 0.4f),
        WEST_NORTH_WITH_LEG("west_north_with_leg_westnorth", 0.4f),
        NORTH_EAST_SOUTH("north_east_south", 0.8f),
        EAST_SOUTH_WEST("east_south_west", 0.8f),
        SOUTH_WEST_NORTH("south_west_north", 0.8f),
        WEST_NORTH_EAST("west_north_east", 0.8f),
        NORTH_EAST_SOUTH_WITH_LEG_NORTHEAST("north_east_south_with_leg_northeast", 0.8f),
        NORTH_EAST_SOUTH_WITH_LEG_EASTSOUTH("north_east_south_with_leg_eastsouth", 0.8f),
        NORTH_EAST_SOUTH_WITH_LEG_NORTHEAST_EASTSOUTH("north_east_south_with_leg_northeast_eastsouth", 0.4f),
        EAST_SOUTH_WEST_WITH_LEG_EASTSOUTH("east_south_west_with_leg_eastsouth", 0.8f),
        EAST_SOUTH_WEST_WITH_LEG_SOUTHWEST("east_south_west_with_leg_southwest", 0.8f),
        EAST_SOUTH_WEST_WITH_LEG_EASTSOUTH_SOUTHWEST("east_south_west_with_leg_eastsouth_southwest", 0.4f),
        SOUTH_WEST_NORTH_WITH_LEG_WESTNORTH("south_west_north_with_leg_westnorth", 0.8f),
        SOUTH_WEST_NORTH_WITH_LEG_SOUTHWEST("south_west_north_with_leg_southwest", 0.8f),
        SOUTH_WEST_NORTH_WITH_LEG_WESTNORTH_SOUTHWEST("south_west_north_with_leg_westnorth_southwest", 0.4f),
        WEST_NORTH_EAST_WITH_LEG_NORTHEAST("west_north_east_with_leg_northeast", 0.8f),
        WEST_NORTH_EAST_WITH_LEG_WESTNORTH("west_north_east_with_leg_westnorth", 0.8f),
        WEST_NORTH_EAST_WITH_LEG_NORTHEAST_WESTNORTH("west_north_east_with_leg_northeast_westnorth", 0.4f),
        ALL("north_east_south_west", 1.0f),
        ALL_WITH_LEG_ALL("north_east_south_west_with_leg_northeast_eastsouth_southwest_westnorth", 0.4f),
        ALL_WITH_LEG_NORTHEAST("north_east_south_west_with_leg_northeast", 0.8f),
        ALL_WITH_LEG_NORTHEAST_EASTSOUTH("north_east_south_west_with_leg_northeast_eastsouth", 0.8f),
        ALL_WITH_LEG_NORTHEAST_EASTSOUTH_SOUTHWEST("north_east_south_west_with_leg_northeast_eastsouth_southwest", 0.8f),
        ALL_WITH_LEG_EASTSOUTH("north_east_south_west_with_leg_eastsouth", 0.8f),
        ALL_WITH_LEG_EASTSOUTH_SOUTHWEST("north_east_south_west_with_leg_eastsouth_southwest", 0.8f),
        ALL_WITH_LEG_EASTSOUTH_SOUTHWEST_WESTNORTH("north_east_south_west_with_leg_eastsouth_southwest_westnorth", 0.8f),
        ALL_WITH_LEG_SOUTHWEST("north_east_south_west_with_leg_southwest", 0.8f),
        ALL_WITH_LEG_SOUTHWEST_WESTNORTH("north_east_south_west_with_leg_southwest_westnorth", 0.8f),
        ALL_WITH_LEG_SOUTHWEST_WESTNORTH_NORTHEAST("north_east_south_west_with_leg_southwest_westnorth_northeast", 0.8f),
        ALL_WITH_LEG_WESTNORTH("north_east_south_west_with_leg_westnorth", 0.8f),
        ALL_WITH_LEG_WESTNORTH_NORTHEAST("north_east_south_west_with_leg_westnorth_northeast", 0.8f),
        ALL_WITH_LEG_WESTNORTH_NORTHEAST_EASTSOUTH("north_east_south_west_with_leg_westnorth_northeast_eastsouth", 0.8f),
        ALL_WITH_LEG_NORTHEAST_SOUTHWEST("north_east_south_west_with_leg_northeast_southwest", 0.8f),
        ALL_WITH_LEG_EASTSOUTH_WESTNORTH("north_east_south_west_with_leg_eastsouth_westnorth", 0.8f);

        public static final Map<Integer, Shape> PACKED_VALUE_TO_SHAPE;
        private final String name;
        private final int packedValue;
        private final float bounceScale;

        private Shape(String name, float bounceScale) {
            this.name = name;
            this.packedValue = Shape.createPackedValue(name);
            this.bounceScale = bounceScale;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Shape fromPackedValue(int packedValue) {
            return PACKED_VALUE_TO_SHAPE.getOrDefault(packedValue, DEFAULT);
        }

        private static int createPackedValue(String name) {
            List<String> values = Arrays.asList(name.split("_"));
            boolean north = values.contains("north");
            boolean east = values.contains("east");
            boolean south = values.contains("south");
            boolean west = values.contains("west");
            boolean lnw = values.contains("westnorth");
            boolean lne = values.contains("northeast");
            boolean lse = values.contains("eastsouth");
            boolean lsw = values.contains("southwest");
            return Shape.createPackedValue(north, east, south, west, lnw, lne, lse, lsw);
        }

        public static int createPackedValue(boolean n, boolean e, boolean s, boolean w, boolean cnw, boolean cne, boolean cse, boolean csw) {
            boolean[] states = new boolean[]{n, e, s, w, cnw, cne, cse, csw};
            int value = 0;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                value |= 1 << i;
            }
            return value;
        }

        static {
            PACKED_VALUE_TO_SHAPE = Arrays.stream(Shape.values()).collect(Collectors.toMap(shape -> shape.packedValue, shape -> shape));
        }
    }
}

