/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PlateBlockEntity
extends BasicLootBlockEntity {
    protected int rotation;

    public PlateBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.PLATE.get(), pos, state);
    }

    public PlateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 1);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "plate", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return null;
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return slotIndex == 0 && this.isSlotInsertable(slotIndex);
    }

    public boolean placeItem(Player player, ItemStack stack) {
        if (this.canPlaceItem(0, stack)) {
            this.rotation = player.getDirection().get2DDataValue();
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.setItem(0, copy);
            return true;
        }
        return false;
    }

    public boolean popItem() {
        if (this.level != null && !this.getItem(0).isEmpty()) {
            ItemStack stack = this.getItem(0);
            BlockPos pos = this.worldPosition;
            ItemEntity entity = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, stack.copy());
            this.setItem(0, ItemStack.EMPTY);
            this.level.addFreshEntity((Entity)entity);
            return true;
        }
        return false;
    }

    public boolean eat(Player player) {
        ItemStack stack = this.getItem(0);
        if (stack.has(DataComponents.CONSUMABLE) && player.canEat(false)) {
            Services.ENTITY.spawnFoodParticles(player, stack);
            Objects.requireNonNull((Consumable)stack.get(DataComponents.CONSUMABLE)).onConsume(player.level(), (LivingEntity)player, stack);
            this.setChanged();
            return true;
        }
        return false;
    }

    public Direction getPlacedDirection() {
        return Direction.from2DDataValue((int)this.rotation);
    }

    public void setChanged() {
        super.setChanged();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Rotation", 3)) {
            this.rotation = tag.getInt("Rotation");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("Rotation", this.rotation);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

