/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class DeferredElectricRenderer
implements ResourceManagerReloadListener {
    public static final String PASS_NAME = "refurbished_furniture_electricity";
    public static final ResourceLocation ID = Utils.resource("deferred_electric_renderer");
    private static DeferredElectricRenderer instance;
    private final ResourceLocation nodeTexture = Utils.resource("textures/misc/electricity_nodes.png");
    private final List<BiConsumer<PoseStack, VertexConsumer>> deferredDrawCalls = new LinkedList<BiConsumer<PoseStack, VertexConsumer>>();
    private TextureTarget electricityTarget;
    private ResourceHandle<TextureTarget> handle;

    public static DeferredElectricRenderer get() {
        if (instance == null) {
            instance = new DeferredElectricRenderer();
        }
        return instance;
    }

    private DeferredElectricRenderer() {
    }

    public void onResourceManagerReload(ResourceManager manager) {
        if (this.electricityTarget != null) {
            this.electricityTarget.destroyBuffers();
        }
        Window window = Minecraft.getInstance().getWindow();
        this.electricityTarget = new TextureTarget(window.getWidth(), window.getHeight(), true);
        this.electricityTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.electricityTarget.clear();
    }

    public void resize(int width, int height) {
        if (this.electricityTarget != null) {
            this.electricityTarget.resize(width, height);
        }
    }

    public void setupFramePass(FrameGraphBuilder builder, Camera camera) {
        if (this.electricityTarget != null && LinkHandler.isHoldingWrench()) {
            ResourceHandle handle = builder.importExternal(PASS_NAME, (Object)this.electricityTarget);
            FramePass pass = builder.addPass(PASS_NAME);
            this.handle = pass.readsAndWrites(handle);
            pass.executes(() -> this.drawToTexture(camera, this.electricityTarget));
        } else {
            this.deferredDrawCalls.clear();
        }
    }

    public void deferDraw(BiConsumer<PoseStack, VertexConsumer> consumer) {
        this.deferredDrawCalls.add(consumer);
    }

    public void drawColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public void drawInvertedColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)ARGB.red((int)colour) / 255.0f;
        float green = (float)ARGB.green((int)colour) / 255.0f;
        float blue = (float)ARGB.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public void drawTexturedBox(Matrix4f matrix, VertexConsumer consumer, AABB box, float minU, float minV, float maxU, float maxV) {
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drawToTexture(Camera camera, TextureTarget texture) {
        texture.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        texture.clear();
        texture.bindWrite(false);
        PoseStack stack = new PoseStack();
        stack.pushPose();
        Vec3 view = camera.getPosition();
        stack.translate(-view.x(), -view.y(), -view.z());
        this.draw(stack);
        stack.popPose();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    private void draw(PoseStack pose) {
        if (this.deferredDrawCalls.isEmpty()) {
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX_COLOR);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.nodeTexture);
        pose.pushPose();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (BiConsumer<PoseStack, VertexConsumer> consumer : this.deferredDrawCalls) {
            consumer.accept(pose, (VertexConsumer)builder);
        }
        MeshData data = builder.build();
        if (data != null) {
            BufferUploader.drawWithShader((MeshData)data);
        }
        pose.popPose();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        this.deferredDrawCalls.clear();
    }

    public void blitToScreen() {
        if (this.handle != null) {
            Window window = Minecraft.getInstance().getWindow();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            ((TextureTarget)this.handle.get()).blitAndBlendToScreen(window.getWidth(), window.getHeight());
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
        this.handle = null;
    }
}

