/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.image.TextureCache;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;

public class NeoForgeRenderType
extends RenderType {
    private static final Function<ResourceLocation, RenderType> TELEVISION_SCREEN = Util.memoize(id -> RenderType.create((String)"refurbished_furniture_television_screen", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(LIGHTMAP).setShaderState(RENDERTYPE_SOLID_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(id, TriState.FALSE, false)).createCompositeState(true)));
    private static final Function<ResourceLocation, RenderType> PALETTE_IMAGE = id -> RenderType.create((String)"refurbished_furniture_palette_image", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderType.LIGHTMAP).setShaderState(RENDERTYPE_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new DoorMatTextureStateShard((ResourceLocation)id)).createCompositeState(true));

    public static RenderType televisionScreen(ResourceLocation id) {
        return TELEVISION_SCREEN.apply(id);
    }

    public NeoForgeRenderType(String id, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean b1, boolean b2, Runnable run1, Runnable run2) {
        super(id, format, mode, bufferSize, b1, b2, run1, run2);
        throw new UnsupportedOperationException();
    }

    public static RenderType createPaletteImage(ResourceLocation id) {
        return PALETTE_IMAGE.apply(id);
    }

    private static class DoorMatTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        private final Optional<ResourceLocation> texture;

        public DoorMatTextureStateShard(ResourceLocation id) {
            super(() -> {
                AbstractTexture texture = TextureCache.get().getTexture(id);
                texture.setFilter(TriState.FALSE, false);
                RenderSystem.setShaderTexture((int)0, (int)texture.getId());
            }, () -> {});
            this.texture = Optional.of(id);
        }

        protected Optional<ResourceLocation> cutoutTexture() {
            return this.texture;
        }
    }
}

