/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IProcessingMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class AbstractMicrowaveScreen<T extends AbstractContainerMenu & IPowerSwitchMenu>
extends ElectricityContainerScreen<T> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/microwave.png");
    protected OnOffSlider slider;

    public AbstractMicrowaveScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.initWidgets();
    }

    protected void initWidgets() {
        this.slider = (OnOffSlider)this.addRenderableWidget((GuiEventListener)new OnOffSlider(this.leftPos + this.imageWidth - 22 - 6, this.topPos + 5, Components.GUI_TOGGLE_POWER, btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((IPowerSwitchMenu)this.menu).isEnabled());
        super.render(graphics, mouseX, mouseY, partialTick);
        this.afterRender(graphics, mouseX, mouseY, partialTick);
    }

    protected void afterRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        graphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((IProcessingMenu)this.menu).getMaxProcessTime() > 0 && ((IProcessingMenu)this.menu).getProcessTime() >= 0) {
            int width = (int)Math.ceil(25.0f * ((float)((IProcessingMenu)this.menu).getProcessTime() / (float)((IProcessingMenu)this.menu).getMaxProcessTime()));
            graphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos + 71, this.topPos + 34, 176.0f, 0.0f, width, 17, 256, 256);
        }
        if (((IProcessingMenu)this.menu).getProcessTime() > 0 && ((IProcessingMenu)this.menu).getMaxProcessTime() > 0 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 71, this.topPos + 34, 25, 17)) {
            this.setTooltipForNextRenderPass((Component)Utils.translation("gui", "progress", ((IProcessingMenu)this.menu).getProcessTime(), Components.GUI_SLASH, ((IProcessingMenu)this.menu).getMaxProcessTime()));
        }
    }
}

