/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.CuttingBoardBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.TelevisionBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.CustomSheets;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.ElectricBlockEntityRenderer;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class TelevisionBlockEntityRenderer
implements BlockEntityRenderer<TelevisionBlockEntity> {
    public TelevisionBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TelevisionBlockEntity television, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        if (television.isNodePowered()) {
            poseStack.pushPose();
            Direction direction = (Direction)television.getBlockState().getValue((Property)CuttingBoardBlock.DIRECTION);
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YN.rotation(1.5707964f * (float)direction.get2DDataValue()));
            poseStack.translate(-0.5, 0.0, -0.345);
            float offset = 0.003125f;
            Matrix4f matrix = poseStack.last().pose();
            Material channelMaterial = CustomSheets.getTelevisionChannelMaterial(television.getCurrentChannel().id());
            VertexConsumer consumer = channelMaterial.buffer(source, ClientServices.PLATFORM::getTelevisionScreenRenderType);
            consumer.addVertex(matrix, 0.75f + offset, 0.625f + offset, 0.0f);
            consumer.setColor(255, 255, 255, 255);
            consumer.setUv(0.0f, 0.0f);
            consumer.setLight(0xF000F0);
            consumer.setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 0.75f + offset, 0.1875f - offset, 0.0f);
            consumer.setColor(255, 255, 255, 255);
            consumer.setUv(0.0f, 1.0f);
            consumer.setLight(0xF000F0);
            consumer.setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 0.25f - offset, 0.1875f - offset, 0.0f);
            consumer.setColor(255, 255, 255, 255);
            consumer.setUv(1.0f, 1.0f);
            consumer.setLight(0xF000F0);
            consumer.setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 0.25f - offset, 0.625f + offset, 0.0f);
            consumer.setColor(255, 255, 255, 255);
            consumer.setUv(1.0f, 0.0f);
            consumer.setLight(0xF000F0);
            consumer.setNormal(0.0f, 1.0f, 0.0f);
            poseStack.popPose();
        }
        ElectricBlockEntityRenderer.drawNodeAndConnections(television);
    }
}

