/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.ToasterBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ToasterBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.ElectricBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class ToasterBlockEntityRenderer
implements BlockEntityRenderer<ToasterBlockEntity> {
    private final ItemRenderer renderer;

    public ToasterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.getItemRenderer();
    }

    public void render(ToasterBlockEntity toaster, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, toaster.isHeating() ? 0.375 : 0.4375, 0.5);
        Direction direction = (Direction)toaster.getBlockState().getValue((Property)ToasterBlock.DIRECTION);
        Level level = toaster.getLevel();
        this.drawItem(toaster.getItem(0), 1, direction, level, poseStack, source, light, overlay);
        this.drawItem(toaster.getItem(1), -1, direction, level, poseStack, source, light, overlay);
        poseStack.popPose();
        ElectricBlockEntityRenderer.drawNodeAndConnections(toaster);
    }

    private void drawItem(ItemStack stack, int offset, Direction direction, Level level, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            Vec3i normal = direction.getUnitVec3i();
            poseStack.translate(0.095 * (double)normal.getX() * (double)offset, 0.0, 0.095 * (double)normal.getZ() * (double)offset);
            poseStack.mulPose(direction.getRotation());
            poseStack.mulPose(Axis.XN.rotation(1.5707964f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            this.renderer.renderStatic(stack, ItemDisplayContext.NONE, light, overlay, poseStack, source, level, 0);
            poseStack.popPose();
        }
    }
}

