/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.util.AudioHelper;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class PaddleBallGraphics
extends DisplayableProgram<PaddleBall> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/program/paddle_ball.png");
    private float ballX;
    private float lastBallX;
    private float ballY;
    private float lastBallY;
    private float ballVelocityX;
    private float ballVelocityY;
    private float playerPos;
    private float lastPlayerPos;
    private float targetPlayerPos;
    private float opponentPos;
    private float lastOpponentPos;
    private float targetOpponentPos;
    private int playerScore;
    private int opponentScore;
    private int scoreSide;
    private int scoreAnimation;
    @Nullable
    private Component displayLabel;
    private Boolean wonGame;
    private boolean playing;
    private boolean leftPaddle;
    private String opponentName = "Opponent";

    public PaddleBallGraphics(PaddleBall program) {
        super(program, 200, 100);
        this.setScene(new MainMenuScene(this));
    }

    @Override
    public void tick() {
        this.lastBallX = this.ballX;
        this.lastBallY = this.ballY;
        this.lastPlayerPos = this.playerPos;
        this.lastOpponentPos = this.opponentPos;
        this.ballX += this.ballVelocityX;
        this.ballY += this.ballVelocityY;
        this.playerPos = this.targetPlayerPos;
        this.opponentPos = this.targetOpponentPos;
        super.tick();
    }

    @Override
    public boolean blocksNavigation() {
        return this.playing;
    }

    public void updatePaddles(float playerPos, float opponentPos) {
        this.targetPlayerPos = this.leftPaddle ? playerPos : opponentPos;
        this.targetOpponentPos = this.leftPaddle ? opponentPos : playerPos;
    }

    public void updateBall(float ballX, float ballY, float velocityX, float velocityY) {
        this.ballX = ballX;
        this.ballY = ballY;
        this.ballVelocityX = velocityX;
        this.ballVelocityY = velocityY;
    }

    public void handleOpponentName(String name) {
        this.opponentName = name;
    }

    public void handleEvent(byte event) {
        switch (event) {
            case 1: {
                this.reset();
                this.playing = true;
                this.setScene(new GameScene(this));
                break;
            }
            case 2: {
                this.leftPaddle = true;
                break;
            }
            case 3: {
                this.leftPaddle = false;
                break;
            }
            case 4: {
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_WIN.get(), 1.0f, 0.5f);
                this.displayLabel = this.translation("win_game");
                this.wonGame = true;
                this.playing = false;
                break;
            }
            case 5: {
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_LOSE.get(), 1.0f, 0.5f);
                this.displayLabel = this.translation("lose_game");
                this.wonGame = false;
                this.playing = false;
                break;
            }
            case 6: {
                ++this.playerScore;
                this.scoreSide = 1;
                this.scoreAnimation = 40;
                if (this.playerScore >= 7) break;
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_SUCCESS.get(), 1.0f, 0.5f);
                break;
            }
            case 7: {
                ++this.opponentScore;
                this.scoreSide = 0;
                this.scoreAnimation = 40;
                if (this.opponentScore >= 7) break;
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_FAIL.get(), 1.0f, 0.5f);
                break;
            }
            case 8: {
                this.displayLabel = this.translation("opponent_left");
                this.wonGame = false;
                break;
            }
            case 40: {
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_HIT.get(), 1.0f, 0.5f);
            }
        }
    }

    private void reset() {
        this.displayLabel = null;
        this.wonGame = null;
        this.playerScore = 0;
        this.opponentScore = 0;
        this.ballVelocityX = 0.0f;
        this.ballVelocityY = 0.0f;
        this.scoreAnimation = 0;
        this.opponentName = "Opponent";
    }

    private static class MainMenuScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MenuButton playAiButton;
        private final MenuButton playVsButton;

        public MainMenuScene(PaddleBallGraphics game) {
            this.game = game;
            this.playAiButton = this.addWidget(new MenuButton(100, 16, this.game.translation("play_ai"), btn -> Network.getPlay().sendToServer((Object)new MessagePaddleBall.Action(PaddleBall.Action.JOIN_GAME, 0))));
            this.playAiButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
            this.playVsButton = this.addWidget(new MenuButton(100, 16, this.game.translation("play_vs"), btn -> {
                Network.getPlay().sendToServer((Object)new MessagePaddleBall.Action(PaddleBall.Action.JOIN_GAME, 1));
                game.setScene(new PendingScene(game));
            }));
            this.playVsButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
            Minecraft mc = Minecraft.getInstance();
            if ((mc.getSingleplayerServer() == null || mc.isSingleplayer()) && mc.getCurrentServer() == null) {
                this.playVsButton.setTooltip(Tooltip.create((Component)this.game.translation("server_required")));
                this.playVsButton.active = false;
            }
            game.playing = false;
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.playAiButton.setPosition(contentStart + (this.game.width - this.playAiButton.getWidth()) / 2, contentTop + 45);
            this.playVsButton.setPosition(contentStart + (this.game.width - this.playVsButton.getWidth()) / 2, contentTop + 65);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.blit(RenderType::guiTextured, TEXTURE, (this.game.width - 128) / 2, 10, 16.0f, 0.0f, 128, 24, 256, 256);
        }

        private static class MenuButton
        extends ComputerButton {
            public MenuButton(int width, int height, Component label, Button.OnPress onPress) {
                super(width, height, label, onPress);
            }

            @Override
            protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(graphics, mouseX, mouseY, partialTick);
                if (this.isActive() && this.isHoveredOrFocused()) {
                    graphics.blit(RenderType::guiTextured, TEXTURE, this.getX() - 6, this.getY() + 6, 12.0f, 0.0f, 4, 4, 256, 256);
                    graphics.blit(RenderType::guiTextured, TEXTURE, this.getX() + this.getWidth() + 2, this.getY() + 6, 12.0f, 0.0f, 4, 4, 256, 256);
                }
            }
        }
    }

    private static class GameScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MainMenuScene.MenuButton backButton;

        public GameScene(PaddleBallGraphics game) {
            this.game = game;
            this.backButton = this.addWidget(new MainMenuScene.MenuButton(100, 16, this.game.translation("main_menu"), btn -> game.setScene(new MainMenuScene(game))));
            this.backButton.setBackgroundHighlightColour(-12107714);
            this.backButton.setTextHighlightColour(-14540251);
            this.backButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.setPosition(contentStart + (this.game.width - this.backButton.getWidth()) / 2, contentTop + 60);
        }

        @Override
        public void tick() {
            this.sendInputToServer();
            if (this.game.scoreAnimation > 0) {
                --this.game.scoreAnimation;
            }
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.backButton.active = this.game.wonGame != null;
            this.backButton.visible = this.game.wonGame != null;
            Minecraft mc = Minecraft.getInstance();
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate(100.0f, 4.0f, 0.0f);
            stack.pushPose();
            String label = Integer.toString(this.game.playerScore);
            int width = mc.font.width(label) * 2;
            stack.translate((float)(-width - 7), 0.0f, 0.0f);
            stack.scale(2.0f, 2.0f, 2.0f);
            graphics.drawString(mc.font, label, 0, 0, -13684941, false);
            stack.popPose();
            stack.pushPose();
            stack.scale(2.0f, 2.0f, 2.0f);
            int breakWidth = mc.font.width(label) / 2;
            graphics.drawString(mc.font, "-", -breakWidth, 0, -13684941, false);
            stack.popPose();
            stack.pushPose();
            stack.translate(7.0f, 0.0f, 0.0f);
            stack.scale(2.0f, 2.0f, 2.0f);
            graphics.drawString(mc.font, Integer.toString(this.game.opponentScore), 0, 0, -13684941, false);
            stack.popPose();
            stack.popPose();
            graphics.drawString(mc.font, this.game.translation("you"), 5, 5, -13684941, false);
            String opponentName = this.game.opponentName;
            graphics.drawString(mc.font, opponentName, 195 - mc.font.width(opponentName), 5, -13684941, false);
            stack.pushPose();
            float smoothHostPos = Mth.lerp((float)partialTick, (float)this.game.lastPlayerPos, (float)this.game.playerPos);
            stack.translate(4.0f, smoothHostPos, 0.0f);
            graphics.blit(RenderType::guiTextured, TEXTURE, 0, 0, 0.0f, 0.0f, 6, 28, 6, 28, 256, 256);
            stack.popPose();
            stack.pushPose();
            float smoothOpponentPos = Mth.lerp((float)partialTick, (float)this.game.lastOpponentPos, (float)this.game.opponentPos);
            stack.translate(192.0f, smoothOpponentPos, 0.0f);
            graphics.blit(RenderType::guiTextured, TEXTURE, -2, 0, 6.0f, 0.0f, 6, 28, 6, 28, 256, 256);
            stack.popPose();
            stack.pushPose();
            float smoothBallX = Mth.lerp((float)partialTick, (float)this.game.lastBallX, (float)this.game.ballX);
            float smoothBallY = Mth.lerp((float)partialTick, (float)this.game.lastBallY, (float)this.game.ballY);
            smoothBallX = this.game.leftPaddle ? smoothBallX : 200.0f - smoothBallX;
            stack.translate(smoothBallX, smoothBallY, 0.0f);
            graphics.blit(RenderType::guiTextured, TEXTURE, 0, 0, 12.0f, 0.0f, 4, 4, 4, 4, 256, 256);
            stack.popPose();
            if (this.game.scoreAnimation > 0 && this.game.scoreAnimation / 5 % 2 == 0) {
                stack.pushPose();
                stack.translate((float)(196 * this.game.scoreSide), 0.0f, 0.0f);
                graphics.fill(0, 0, 4, 100, -10143432);
                stack.popPose();
            }
            if (this.game.wonGame != null && this.game.displayLabel != null) {
                Component bannerLabel = this.game.displayLabel;
                int bannerColour = this.game.wonGame != false ? -13147337 : -10143432;
                graphics.drawCenteredString(mc.font, bannerLabel, this.game.width / 2, 40, bannerColour);
            }
        }

        private void sendInputToServer() {
            boolean up = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)265);
            boolean down = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)264);
            byte input = (byte)(up && down ? 0 : (up ? 1 : (down ? 2 : 0)));
            Network.getPlay().sendToServer((Object)new MessagePaddleBall.Action(PaddleBall.Action.INPUT, input));
        }
    }

    private static class PendingScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MainMenuScene.MenuButton backButton;

        private PendingScene(PaddleBallGraphics game) {
            this.game = game;
            this.backButton = this.addWidget(new MainMenuScene.MenuButton(100, 16, this.game.translation("cancel"), btn -> {
                Network.getPlay().sendToServer((Object)new MessagePaddleBall.Action(PaddleBall.Action.UPDATE_STATE, 0));
                game.setScene(new MainMenuScene(game));
            }));
            this.backButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.setPosition(contentStart + (this.game.width - this.backButton.getWidth()) / 2, contentTop + 65);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.blit(RenderType::guiTextured, TEXTURE, (this.game.width - 128) / 2, 10, 16.0f, 0.0f, 128, 24, 256, 256);
            String loading = switch ((int)(Util.getMillis() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            Minecraft mc = Minecraft.getInstance();
            graphics.drawCenteredString(mc.font, loading, this.game.width / 2, 50, -2896706);
            graphics.drawCenteredString(mc.font, this.game.translation("searching_players"), this.game.width / 2, 40, -2896706);
        }
    }
}

