/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ProgramShortcutButton
extends ComputerButton {
    private final ComputerScreen screen;
    private final int index;
    private final Icon icon;

    public ProgramShortcutButton(ComputerScreen screen, int index, int width, int height, Component label, Icon icon, Button.OnPress onPress) {
        super(width, height, (Component)label.copy(), onPress);
        this.screen = screen;
        this.index = index;
        this.icon = icon;
        this.setOutlineColour(0);
        this.setBackgroundColour(0);
        this.setBackgroundHighlightColour(-10923954);
        this.setBackgroundDisabledColour(0);
        this.setOutlineDisabledColour(0);
        this.setTextDisabledColour(1431916622);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.active = this.screen.getOrCreateWindow() == null;
        graphics.fill(this.getX() + 1, this.getY(), this.getX() + this.getWidth() - 1, this.getY() + this.getHeight(), this.getOutlineColour());
        graphics.fill(this.getX(), this.getY() + 1, this.getX() + this.getWidth(), this.getY() + this.getHeight() - 1, this.getOutlineColour());
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, this.getBackgroundColour());
        graphics.blit(RenderType::guiTextured, this.icon.texture(), this.getX() + (this.width - 16) / 2, this.getY() + 4, (float)this.icon.u(), (float)this.icon.v(), 16, 16, 128, 128);
        PoseStack pose = graphics.pose();
        pose.pushPose();
        Font font = Minecraft.getInstance().font;
        float scale = 0.666f;
        int labelWidth = font.width((FormattedText)this.getMessage());
        int labelX = (int)((float)this.getX() + ((float)this.width - (float)labelWidth * scale) / 2.0f) + 1;
        int n = this.getY() + this.height;
        Objects.requireNonNull(font);
        int labelY = n - 9;
        pose.translate((float)labelX, (float)labelY, 0.0f);
        pose.scale(scale, scale, scale);
        graphics.drawString(Minecraft.getInstance().font, this.getMessage(), 0, 0, this.getTextColour(), false);
        pose.popPose();
    }

    protected boolean isValidClickButton(int button) {
        return this.screen.getOrCreateWindow() == null;
    }

    public int getIndex() {
        return this.index;
    }
}

