/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.image;

import com.mojang.blaze3d.platform.NativeImage;
import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TextureCache {
    private static final long EXPIRE_TIME = 10000L;
    private static TextureCache instance;
    private final Map<ResourceLocation, Entry> entries = new HashMap<ResourceLocation, Entry>();

    public static TextureCache get() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    private TextureCache() {
    }

    public void tick() {
        this.entries.entrySet().removeIf(e -> {
            Entry entry = (Entry)e.getValue();
            if (entry.isExpired()) {
                entry.release();
                return true;
            }
            return false;
        });
    }

    @Nullable
    public ResourceLocation getOrCacheImage(IPaintable paintable) {
        PaletteImage image = paintable.getImage();
        if (image != null) {
            Entry entry = this.entries.get(image.getId());
            if (entry == null || entry.isExpired()) {
                if (entry != null) {
                    entry.release();
                }
                entry = new Entry(image);
                this.entries.put(image.getId(), entry);
            }
            entry.ping();
            return image.getId();
        }
        return null;
    }

    @Nullable
    public RenderType getRenderType(IPaintable paintable) {
        ResourceLocation id = this.getOrCacheImage(paintable);
        Entry entry = this.entries.get(id);
        if (entry != null && !entry.isExpired()) {
            return entry.getRenderType();
        }
        return null;
    }

    public AbstractTexture getTexture(ResourceLocation id) {
        Entry entry = this.entries.get(id);
        if (entry != null && !entry.isExpired()) {
            return entry.texture;
        }
        return Minecraft.getInstance().getTextureManager().getTexture(MissingTextureAtlasSprite.getLocation());
    }

    private static NativeImage convertToNativeImage(PaletteImage image) {
        NativeImage nativeImage = new NativeImage(image.width, image.height, false);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                nativeImage.setPixel(x, y, PaletteImage.COLOURS[image.get(x, y)]);
            }
        }
        return nativeImage;
    }

    private static class Entry {
        private final ResourceLocation id;
        private final DynamicTexture texture;
        private final RenderType renderType;
        private long lastDrawTime;
        private boolean expired;

        public Entry(PaletteImage image) {
            this.id = image.getId();
            this.texture = new DynamicTexture(TextureCache.convertToNativeImage(image));
            Minecraft.getInstance().getTextureManager().register(image.getId(), (AbstractTexture)this.texture);
            this.lastDrawTime = Util.getMillis();
            this.renderType = ClientServices.PLATFORM.createPaletteImageRenderType(this.id);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RenderType getRenderType() {
            return this.renderType;
        }

        public void ping() {
            this.lastDrawTime = Util.getMillis();
        }

        public boolean isExpired() {
            return this.expired || Util.getMillis() - this.lastDrawTime > 10000L;
        }

        public void release() {
            if (!this.expired) {
                Minecraft.getInstance().getTextureManager().release(this.id);
                this.expired = true;
            }
        }
    }
}

