/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.util.TaskRunner;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModDataComponents;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.mail.PackageInfo;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PackageItem
extends Item {
    public PackageItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        PackageInfo info = (PackageInfo)stack.get((DataComponentType)ModDataComponents.PACKAGE_INFO.get());
        if (info != null) {
            info.sender().ifPresent(s -> lines.add((Component)Utils.translation("gui", "package_sent_by", s).withStyle(ChatFormatting.AQUA)));
            info.message().ifPresent(s -> TaskRunner.runIf((Environment)Environment.CLIENT, () -> () -> ScreenHelper.splitText(s, 170).forEach(component -> lines.add((Component)component.withStyle(ChatFormatting.GRAY)))));
        }
        lines.add((Component)Utils.translation("gui", "package_open", new Object[0]).withStyle(ChatFormatting.YELLOW));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            float pitch = 0.9f + 0.2f * level.random.nextFloat();
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.ITEM_PACKAGE_OPEN.get(), SoundSource.PLAYERS, 1.0f, pitch);
            PackageItem.getPackagedItems(stack).stream().forEach(s -> Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)s));
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        stack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public static ItemContainerContents getPackagedItems(ItemStack stack) {
        return (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
    }

    public static ItemStack create(Container container, @Nullable String message, @Nullable String sender) {
        return PackageItem.create(BlockEntityHelper.nonNullListFromContainer(container), message, sender);
    }

    public static ItemStack create(NonNullList<ItemStack> items, @Nullable String message, @Nullable String sender) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.PACKAGE.get());
        stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(items));
        stack.set((DataComponentType)ModDataComponents.PACKAGE_INFO.get(), (Object)PackageInfo.create(message, sender));
        return stack;
    }
}

