/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.PlayMessageContext;
import com.mrcrayfish.furniture.refurbished.network.play.ServerPlayHandler;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record MessageSendPackage(UUID mailboxId, String message) {
    private final String message;
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSendPackage> STREAM_CODEC = StreamCodec.of((buf, message) -> {
        buf.writeUUID(message.mailboxId);
        buf.writeUtf(message.message);
    }, buf -> new MessageSendPackage(buf.readUUID(), buf.readUtf()));

    public static void handle(MessageSendPackage message, PlayMessageContext context) {
        context.execute(() -> ServerPlayHandler.handleMessageSendPackage(message, context.getPlayer().orElse(null), (MessageContext)context));
        context.setHandled(true);
    }

    @Nullable
    public String message() {
        return !this.message.isBlank() ? this.message : null;
    }
}

