/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.block.TelevisionBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTelevisionChannel;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class TelevisionBlockEntity
extends ElectricityModuleBlockEntity
implements ILevelAudio {
    public static final Channel WHITE_NOISE = new Channel(Utils.resource("white_noise"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_WHITE_NOISE.get(), 0);
    public static final Channel BLACK_NOISE = new Channel(Utils.resource("black_noise"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_WHITE_NOISE.get(), 0);
    public static final Channel HEART_SCREENSAVER = new Channel(Utils.resource("heart_screensaver"), () -> null, 10);
    public static final Channel COLOUR_TEST = new Channel(Utils.resource("colour_test"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_COLOUR_TEST.get(), 1);
    public static final Channel HEROBRINE = new Channel(Utils.resource("herobrine"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_COLOUR_TEST.get(), 0);
    public static final Channel DANCE_MUSIC = new Channel(Utils.resource("dance_music"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_DANCE_MUSIC.get(), 10);
    public static final Channel VILLAGER_NEWS = new Channel(Utils.resource("villager_news"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_VILLAGER_NEWS.get(), 10);
    public static final Channel RIP_BLIZZARD = new Channel(Utils.resource("rip_blizzard"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_CHIRP_SONG.get(), 5);
    public static final Channel OCEAN_SUNSET = new Channel(Utils.resource("ocean_sunset"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_OCEAN_SUNSET.get(), 10);
    public static final Channel BLOCK_GAME = new Channel(Utils.resource("block_game"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_BLOCKY_GAME.get(), 10);
    public static final Channel PONG = new Channel(Utils.resource("pong"), () -> ModSounds.BLOCK_TELEVISION_CHANNEL_RETRO_SONG.get(), 10);
    public static final Channel SILLY_FACE = new Channel(Utils.resource("silly_face"), () -> null, 10);
    public static final List<Channel> VIEWABLE_CHANNELS = List.of(HEART_SCREENSAVER, COLOUR_TEST, DANCE_MUSIC, VILLAGER_NEWS, RIP_BLIZZARD, OCEAN_SUNSET, BLOCK_GAME, PONG, SILLY_FACE);
    public static final List<Channel> ALL_CHANNELS = (List)class_156.method_654(new ArrayList(), channels -> {
        channels.add(WHITE_NOISE);
        channels.add(BLACK_NOISE);
        channels.add(HEROBRINE);
        channels.addAll(VIEWABLE_CHANNELS);
    });
    public static final Map<class_2960, Channel> ID_TO_CHANNEL = ALL_CHANNELS.stream().collect(Collectors.toMap(c -> c.id, Function.identity()));
    public static final double MAX_AUDIO_DISTANCE = class_3532.method_34954((int)16);
    protected final class_243 audioPosition;
    protected Channel currentChannel = OCEAN_SUNSET;
    protected Channel lastChannel;
    protected boolean transitioning;
    protected int timer;

    public TelevisionBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.TELEVISION.get(), pos, state);
    }

    public TelevisionBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.audioPosition = pos.method_46558();
    }

    public Channel getCurrentChannel() {
        return this.currentChannel;
    }

    @Override
    public class_3414 getSound() {
        return this.currentChannel.sound().get();
    }

    @Override
    public class_3419 getSource() {
        return class_3419.field_15245;
    }

    @Override
    public class_243 getAudioPosition() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)TelevisionBlock.DIRECTION)) {
            class_2350 direction = ((class_2350)state.method_11654((class_2769)TelevisionBlock.DIRECTION)).method_10153();
            class_2382 normal = direction.method_62675();
            return this.audioPosition.method_1031((double)normal.method_10263() * 0.375, (double)normal.method_10264(), (double)normal.method_10260() * 0.375);
        }
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return !this.method_11015() && this.isNodePowered();
    }

    @Override
    public double getAudioRadiusSqr() {
        return MAX_AUDIO_DISTANCE;
    }

    @Override
    public float getAudioPitch() {
        if (this.currentChannel == HEROBRINE || this.currentChannel == BLACK_NOISE) {
            return 0.25f;
        }
        return 1.0f;
    }

    @Override
    public int getAudioHash() {
        return this.field_11867.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return other == this;
    }

    @Override
    public boolean isNodePowered() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)class_2741.field_12484) && (Boolean)state.method_11654((class_2769)class_2741.field_12484) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)class_2741.field_12484)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public void interact() {
        if (!this.transitioning && this.isNodePowered()) {
            Preconditions.checkState((boolean)(this.field_11863 instanceof class_3218));
            int transitionTime = this.field_11863.field_9229.method_43051(5, 20);
            this.field_11863.method_64310(this.field_11867, this.method_11010().method_26204(), transitionTime);
            this.lastChannel = this.currentChannel;
            this.setChannel(WHITE_NOISE);
            this.transitioning = true;
        }
    }

    public void selectRandomChannel() {
        int randomIndex;
        Preconditions.checkState((boolean)(this.field_11863 instanceof class_3218));
        if (this.field_11863.method_27983() == class_1937.field_25179 && this.field_11867.method_10264() <= 0) {
            this.setChannel(COLOUR_TEST);
            this.transitioning = false;
            return;
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(VIEWABLE_CHANNELS);
        channels.remove(this.lastChannel);
        int totalWeight = channels.stream().mapToInt(Channel::weight).sum();
        int i = this.field_11863.field_9229.method_39332(0, totalWeight);
        for (randomIndex = 0; randomIndex < channels.size() - 1 && (i -= ((Channel)channels.get(randomIndex)).weight()) >= 0; ++randomIndex) {
        }
        this.setChannel((Channel)channels.get(randomIndex));
        this.transitioning = false;
    }

    private void setChannel(Channel channel) {
        Preconditions.checkNotNull((Object)this.field_11863);
        this.currentChannel = channel;
        this.method_5431();
        if (!this.field_11863.method_8608()) {
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageTelevisionChannel(this.field_11867, channel.id));
        }
    }

    public void setChannelFromId(class_2960 id) {
        Channel channel = ID_TO_CHANNEL.get(id);
        if (channel != null) {
            this.setChannel(channel);
        }
    }

    private void specialTick() {
        Preconditions.checkNotNull((Object)this.field_11863);
        if (this.isNodePowered() && this.field_11863.method_27983() == class_1937.field_25179 && this.field_11867.method_10264() <= 0) {
            if (this.currentChannel == COLOUR_TEST) {
                if (this.timer++ >= 200) {
                    this.setChannel(HEROBRINE);
                    this.timer = 0;
                }
            } else if (this.currentChannel == HEROBRINE && this.timer++ == 100) {
                this.setChannel(BLACK_NOISE);
                this.timer = 0;
            }
            return;
        }
        this.timer = 0;
    }

    @Override
    public void moduleTick(class_1937 level) {
        super.moduleTick(level);
        if (!level.field_9236) {
            this.specialTick();
        } else {
            AudioManager.get().playLevelAudio(this);
        }
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        class_2960 id;
        super.method_11014(tag, provider);
        if (tag.method_10573("CurrentChannel", 8) && (id = class_2960.method_12829((String)tag.method_10558("CurrentChannel"))) != null && !id.equals((Object)TelevisionBlockEntity.WHITE_NOISE.id) && ID_TO_CHANNEL.containsKey(id)) {
            this.currentChannel = ID_TO_CHANNEL.get(id);
        }
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.currentChannel != null && this.currentChannel != WHITE_NOISE) {
            tag.method_10582("CurrentChannel", this.currentChannel.id.toString());
        }
    }

    public record Channel(class_2960 id, Supplier<class_3414> sound, int weight) {
    }
}

