/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei.categories;

import com.mrcrayfish.furniture.refurbished.compat.jei.Plugin;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FurnitureRecipeCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.joml.Vector2i;

public class WorkbenchConstructingCategory
extends FurnitureRecipeCategory<WorkbenchContructingRecipe> {
    public static final RecipeType<WorkbenchContructingRecipe> TYPE = RecipeType.create((String)"refurbished_furniture", (String)"workbench_constructing", WorkbenchContructingRecipe.class);
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private List<Pair<Vector2i, IDrawable>> slots = new ArrayList<Pair<Vector2i, IDrawable>>();

    public WorkbenchConstructingCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(Plugin.TEXTURES_2, 0, 0, 118, 64);
        this.icon = helper.createDrawableItemStack(new class_1799((class_1935)ModBlocks.WORKBENCH.get()));
    }

    public RecipeType<WorkbenchContructingRecipe> getRecipeType() {
        return TYPE;
    }

    public class_2561 getTitle() {
        return Utils.translation("jei_category", "workbench_constructing", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WorkbenchContructingRecipe recipe, IFocusGroup focuses) {
        this.slots.clear();
        class_2371<StackedIngredient> materials = recipe.getMaterials();
        int left = 6;
        int top = 6;
        int slotSize = 18;
        int boxSize = 54;
        int width = slotSize * class_3532.method_15340((int)materials.size(), (int)1, (int)3);
        int height = slotSize * class_3532.method_15340((int)class_3532.method_15386((float)((float)materials.size() / 3.0f)), (int)1, (int)3);
        for (int i = 0; i < materials.size(); ++i) {
            int x = left + i % 3 * slotSize + (boxSize - width) / 2;
            int y = top + i / 3 * slotSize + (boxSize - height) / 2;
            StackedIngredient material = (StackedIngredient)materials.get(i);
            List<class_1799> stacks = material.ingredient().method_8105().map(holder -> {
                class_1799 copy = new class_1799((class_1935)holder.comp_349());
                copy.method_7939(material.count());
                return copy;
            }).toList();
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(stacks);
            this.slots.add((Pair<Vector2i, IDrawable>)Pair.of((Object)new Vector2i(x - 1, y - 1), (Object)this.helper.createDrawable(Plugin.TEXTURES_2, 0, 64, 18, 18)));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 24).addItemStack(recipe.getResult());
    }

    public void draw(WorkbenchContructingRecipe recipe, IRecipeSlotsView view, class_332 graphics, double mouseX, double mouseY) {
        this.slots.forEach(pair -> {
            Vector2i pos = (Vector2i)pair.left();
            ((IDrawable)pair.right()).draw(graphics, pos.x(), pos.y());
        });
    }
}

