/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ContainerInput;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_10355;
import net.minecraft.class_1263;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardCombiningRecipe
implements class_1860<ContainerInput> {
    public static final int MAX_INGREDIENTS = 5;
    protected final class_2371<class_1856> ingredients;
    protected final class_1799 result;
    @Nullable
    protected class_9887 placementInfo;

    public CuttingBoardCombiningRecipe(class_2371<class_1856> ingredients, class_1799 result) {
        this.ingredients = ingredients;
        this.result = result;
    }

    public boolean matches(ContainerInput input, class_1937 level) {
        for (int i = 0; i < this.ingredients.size() && i < input.method_59983(); ++i) {
            if (((class_1856)this.ingredients.get(i)).method_8093(input.method_59984(i))) continue;
            return false;
        }
        return true;
    }

    public class_1799 assemble(ContainerInput input, class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    public class_1865<CuttingBoardCombiningRecipe> method_8119() {
        return (class_1865)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
    }

    public class_3956<CuttingBoardCombiningRecipe> method_17716() {
        return (class_3956)ModRecipeTypes.CUTTING_BOARD_COMBINING.get();
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61683(this.ingredients.stream().map(Optional::of).toList());
        }
        return this.placementInfo;
    }

    public class_10355 method_64668() {
        return class_314.field_1810;
    }

    public class_2371<class_1856> getIngredients() {
        return this.ingredients;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public boolean completelyMatches(class_1263 container) {
        if (this.ingredients.size() <= container.method_5439()) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((class_1856)this.ingredients.get(i)).method_8093(container.method_5438(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder
    implements class_5797 {
        private final class_2371<class_1856> ingredients = class_2371.method_10211();
        private final class_1799 result;

        public Builder(class_1799 output) {
            this.result = output;
        }

        public Builder add(class_1856 ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public class_5797 method_33530(String name, class_175<?> criterion) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support unlocking");
        }

        public class_5797 method_33529(@Nullable String group) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support setting the group");
        }

        public class_1792 method_36441() {
            return this.result.method_7909();
        }

        public void method_17972(class_8790 output, class_5321<class_1860<?>> id) {
            this.validate();
            output.method_53819(id, (class_1860)new CuttingBoardCombiningRecipe(this.ingredients, this.result), null);
        }

        private void validate() {
            if (this.ingredients.size() < 2) {
                throw new IllegalStateException("Cutting Board combining recipe must have at least 2 input ingredients");
            }
            if (this.ingredients.size() > 5) {
                throw new IllegalStateException("Cutting Board combining recipe only supports up to 5 input ingredients");
            }
        }
    }

    public static class Serializer
    implements class_1865<CuttingBoardCombiningRecipe> {
        public static final MapCodec<CuttingBoardCombiningRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_1856.field_46095.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            class_2371 inputs = class_2371.method_10211();
            inputs.addAll((Collection)ingredients);
            if (inputs.size() > 5) {
                return DataResult.error(() -> "Too many ingredients");
            }
            if (inputs.isEmpty()) {
                return DataResult.error(() -> "No ingredients");
            }
            return DataResult.success((Object)inputs);
        }, DataResult::success).forGetter(recipe -> recipe.ingredients), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, CuttingBoardCombiningRecipe::new));
        public static final class_9139<class_9129, CuttingBoardCombiningRecipe> STREAM_CODEC = class_9139.method_56437((buf, recipe) -> {
            buf.method_53002(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> class_1856.field_48355.encode(buf, ingredient));
            class_1799.field_48349.encode(buf, (Object)recipe.result);
        }, buf -> {
            int ingredientCount = buf.readInt();
            class_2371 ingredients = class_2371.method_10213((int)ingredientCount, (Object)class_1856.method_8091((class_1935[])new class_1935[0]));
            IntStream.range(0, ingredientCount).forEach(i -> ingredients.set(i, (Object)((class_1856)class_1856.field_48355.decode(buf))));
            class_1799 result = (class_1799)class_1799.field_48349.decode(buf);
            return new CuttingBoardCombiningRecipe((class_2371<class_1856>)ingredients, result);
        });

        public MapCodec<CuttingBoardCombiningRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CuttingBoardCombiningRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

