/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_10355;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2540;
import net.minecraft.class_3542;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9696;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessingRecipe
implements class_1860<class_9696> {
    protected final class_3956<? extends class_1860<class_9696>> type;
    protected final Category category;
    protected final class_1856 ingredient;
    protected final class_1799 result;
    protected final int time;
    @Nullable
    private class_9887 placementInfo;

    public ProcessingRecipe(class_3956<? extends class_1860<class_9696>> type, Category category, class_1856 ingredient, class_1799 result, int time) {
        this.type = type;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public class_3956<? extends class_1860<class_9696>> method_17716() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean matches(class_9696 input, class_1937 level) {
        return this.ingredient.method_8093(input.comp_2676());
    }

    public class_1799 assemble(class_9696 input, class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61682((class_1856)this.ingredient);
        }
        return this.placementInfo;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static <T extends ProcessingRecipe> Builder<T> builder(Factory<T> factory, Category category, class_1856 input, class_1799 output, int processTime) {
        return new Builder<T>(factory, category, input, output, processTime);
    }

    public static enum Category implements class_3542
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final class_3542.class_7292<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public void toNetwork(class_2540 buf) {
            buf.method_10788(this.name, 6);
        }

        public static Category fromNetwork(class_2540 buf) {
            return Category.byName(buf.method_10800(6));
        }

        public static Category byName(String name) {
            return (Category)CODEC.method_47920(name, (Enum)MISC);
        }

        static {
            CODEC = class_3542.method_28140(Category::values);
        }
    }

    public static class Builder<T extends ProcessingRecipe>
    implements class_5797 {
        protected final Category category;
        protected final Factory<T> factory;
        protected final class_1856 input;
        protected final class_1799 output;
        protected final int processTime;
        protected final Map<String, class_175<?>> criteria = new LinkedHashMap();

        private Builder(Factory<T> factory, Category category, class_1856 input, class_1799 output, int processTime) {
            this.factory = factory;
            this.category = category;
            this.input = input;
            this.output = output;
            this.processTime = processTime;
        }

        public class_5797 method_33530(String s, class_175<?> instance) {
            this.criteria.put(s, instance);
            return this;
        }

        public class_5797 method_33529(@Nullable String group) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public class_1792 method_36441() {
            return this.output.method_7909();
        }

        public void method_17972(class_8790 output, class_5321<class_1860<?>> id) {
            class_161.class_162 builder = output.method_53818().method_705("has_the_recipe", class_2119.method_27847(id)).method_703(class_170.class_171.method_753(id)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
            output.method_53819(id, this.factory.create(this.category, this.input, this.output, this.processTime), builder.method_695(id.method_29177().method_45138("recipes/" + this.category.method_15434() + "/")));
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(Category var1, class_1856 var2, class_1799 var3, int var4);
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        public ItemWithCount(class_3956<? extends class_1860<class_9696>> type, Category category, class_1856 ingredient, class_1799 result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements class_1865<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final MapCodec<T> codec;
            private final class_9139<class_9129, T> streamCodec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
                this.streamCodec = class_9139.method_56437((buf, recipe) -> {
                    recipe.category.toNetwork((class_2540)buf);
                    class_1856.field_48355.encode(buf, (Object)recipe.ingredient);
                    class_1799.field_48349.encode(buf, (Object)recipe.result);
                    buf.method_10804(recipe.time);
                }, buf -> {
                    Category category = Category.fromNetwork((class_2540)buf);
                    class_1856 input = (class_1856)class_1856.field_48355.decode(buf);
                    class_1799 output = (class_1799)class_1799.field_48349.decode(buf);
                    int processTime = buf.method_10816();
                    return this.factory.create(category, input, output, processTime);
                });
            }

            public MapCodec<T> method_53736() {
                return this.codec;
            }

            public class_9139<class_9129, T> method_56104() {
                return this.streamCodec;
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        public Item(class_3956<? extends class_1860<class_9696>> type, Category category, class_1856 ingredient, class_1799 result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static ProcessingRecipe fromCookingRecipe(final class_1874 recipe, class_5455 access) {
            return new ProcessingRecipe(recipe.method_17716(), Category.FOOD, recipe.method_64720(), recipe.method_59998(new class_9696(class_1799.field_8037), (class_7225.class_7874)access), recipe.method_8167()){

                public class_1865<? extends class_1860<class_9696>> method_8119() {
                    return recipe.method_8119();
                }

                public class_10355 method_64668() {
                    return recipe.method_64668();
                }

                @Override
                public class_9887 method_61671() {
                    return recipe.method_61671();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements class_1865<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final MapCodec<T> codec;
            private final class_9139<class_9129, T> streamCodec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)class_1799.field_49747.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
                this.streamCodec = class_9139.method_56437((buf, recipe) -> {
                    recipe.category.toNetwork((class_2540)buf);
                    class_1856.field_48355.encode(buf, (Object)recipe.ingredient);
                    class_1799.field_48349.encode(buf, (Object)recipe.result);
                    buf.method_10804(recipe.time);
                }, buf -> {
                    Category category = Category.fromNetwork((class_2540)buf);
                    class_1856 input = (class_1856)class_1856.field_48355.decode(buf);
                    class_1799 output = (class_1799)class_1799.field_48349.decode(buf);
                    int processTime = buf.method_10816();
                    return this.factory.create(category, input, output, processTime);
                });
            }

            public MapCodec<T> method_53736() {
                return this.codec;
            }

            public class_9139<class_9129, T> method_56104() {
                return this.streamCodec;
            }
        }
    }
}

