/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import com.mrcrayfish.furniture.refurbished.client.ClientBootstrap;
import com.mrcrayfish.furniture.refurbished.client.CustomSheets;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.ExtraModels;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.ToolAnimationRenderer;
import com.mrcrayfish.furniture.refurbished.client.registration.ParticleProviderRegister;
import com.mrcrayfish.furniture.refurbished.client.registration.RecipeCategoryRegister;
import com.mrcrayfish.furniture.refurbished.client.registration.ScreenRegister;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.apache.commons.lang3.function.TriFunction;

public class ForgeClientEvents {
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientBootstrap.registerScreens(new ScreenRegister(){

            @Override
            public <T extends AbstractContainerMenu, U extends Screen> void apply(MenuType<T> type, TriFunction<T, Inventory, Component, U> factory) {
                MenuScreens.register(type, (arg_0, arg_1, arg_2) -> factory.apply(arg_0, arg_1, arg_2));
            }
        });
        ClientBootstrap.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
        ClientBootstrap.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        ClientBootstrap.registerRenderTypes(ItemBlockRenderTypes::setRenderLayer);
        ExtraModels.register(FrameworkClientAPI::registerStandaloneModel);
    }

    public static void onRegisterParticleProviders(final RegisterParticleProvidersEvent event) {
        ClientBootstrap.registerParticleProviders(new ParticleProviderRegister(){

            @Override
            public <T extends ParticleOptions> void apply(ParticleType<T> type, ParticleProviderRegister.SpriteProvider<T> provider) {
                event.registerSpriteSet(type, provider::apply);
            }
        });
    }

    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        PoseStack stack = new PoseStack();
        stack.setIdentity();
        stack.mulPose(event.getProjectionMatrix());
        stack.mulPose(event.getCamera().rotation());
        stack.pushPose();
        Vec3 view = event.getCamera().getPosition();
        stack.translate(-view.x(), -view.y(), -view.z());
        float deltaTick = mc.getTimer().getGameTimeDeltaPartialTick(true);
        LinkHandler.get().render((Player)mc.player, stack, mc.renderBuffers().bufferSource(), deltaTick);
        ToolAnimationRenderer.get().render((Level)mc.level, stack, mc.renderBuffers().bufferSource(), deltaTick);
        DeferredElectricRenderer.get().draw(stack);
        stack.popPose();
        mc.renderBuffers().bufferSource().endBatch(ClientServices.PLATFORM.getTelevisionScreenRenderType(CustomSheets.TV_CHANNELS_SHEET));
    }

    public static void onKeyTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getKeyMapping() == mc.options.keyAttack && mc.player != null && mc.level != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get()) && LinkHandler.get().onWrenchLeftClick((Level)mc.level)) {
            event.setCanceled(true);
        }
    }

    public static void onDrawHighlight(RenderHighlightEvent.Block event) {
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND)).is((Item)ModItems.WRENCH.get())) {
            event.setCanceled(true);
        }
    }

    public static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        ClientBootstrap.registerBlockColors((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)event).register(arg_0, arg_1));
    }

    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        ClientBootstrap.registerItemColors((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Item)event).register(arg_0, arg_1));
    }

    public static void onRegisterRecipeCategories(final RegisterRecipeBookCategoriesEvent event) {
        ClientBootstrap.registerRecipeBookCategories(new RecipeCategoryRegister(){

            @Override
            public void applyCategory(RecipeBookType recipeBookType, RecipeBookCategories ... categories) {
                event.registerBookCategories(recipeBookType, List.of(categories));
            }

            @Override
            public void applyAggregate(RecipeBookCategories category, RecipeBookCategories ... categories) {
                event.registerAggregateCategory(category, List.of(categories));
            }

            @Override
            public void applyFinder(RecipeType<?> type, Function<Recipe<?>, RecipeBookCategories> function) {
                event.registerRecipeCategoryFinder(type, function);
            }
        });
    }
}

