/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<ChairBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.f_303492_.fieldOf("wood_type").forGetter(block -> block.type), (App)ChairBlock.m_305607_()).apply((Applicative)builder, ChairBlock::new));
    public static final BooleanProperty TUCKED = BooleanProperty.m_61465_((String)"tucked");
    private final WoodType type;

    public ChairBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<ChairBlock> m_304657_() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape backrestShape = Block.m_49796_((double)12.0, (double)10.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
        VoxelShape seatShape = Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
        VoxelShape backLeftLegShape = Shapes.m_83048_((double)0.75, (double)0.0, (double)0.75, (double)0.875, (double)0.5, (double)0.875);
        VoxelShape backRightLegShape = Shapes.m_83048_((double)0.75, (double)0.0, (double)0.125, (double)0.875, (double)0.5, (double)0.25);
        VoxelShape frontLeftLegShape = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.75, (double)0.25, (double)0.5, (double)0.875);
        VoxelShape frontRightLegShape = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.25, (double)0.5, (double)0.25);
        VoxelShape chairShape = VoxelShapeHelper.combine(List.of(backrestShape, seatShape, backLeftLegShape, backRightLegShape, frontLeftLegShape, frontRightLegShape));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            VoxelShape rotatedChairShape = VoxelShapeHelper.rotateHorizontally(chairShape, direction);
            if (((Boolean)state.m_61143_((Property)TUCKED)).booleanValue()) {
                rotatedChairShape = rotatedChairShape.m_83216_(-0.5 * (double)direction.m_122429_(), 0.0, -0.5 * (double)direction.m_122431_());
            }
            builder.put((Object)state, (Object)rotatedChairShape);
        }
        return builder.build();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean $$5) {
        if (!this.canTuck(state, level, pos) && ((Boolean)state.m_61143_((Property)TUCKED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_6047_() && Seat.availableAt(level, pos) && this.canTuck(state, level, pos)) {
            level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_CHAIR_SLIDE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TUCKED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)TUCKED) == false)), 3);
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.m_61143_((Property)TUCKED)).booleanValue() && Seat.sit(player, pos, Utils.pixels(10.0), ((Direction)state.m_61143_((Property)DIRECTION)).m_122424_())) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TUCKED});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_);
    }

    protected boolean canTuck(BlockState state, Level level, BlockPos pos) {
        BlockPos front = pos.m_121945_(((Direction)state.m_61143_((Property)DIRECTION)).m_122424_());
        return level.m_8055_(front).m_204336_(ModTags.Blocks.TUCKABLE);
    }
}

