/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.block.IKitchenCabinetry;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class KitchenCabinetryBlock
extends FurnitureHorizontalBlock
implements IKitchenCabinetry {
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);

    public KitchenCabinetryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)Shape.DEFAULT)));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape baseShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);
        VoxelShape baseLeftShape = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0);
        VoxelShape baseRightShape = Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0);
        VoxelShape insideCornerLeftShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)14.0);
        VoxelShape insideCornerRightShape = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)13.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Shape shape = (Shape)((Object)state.m_61143_(SHAPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            if (shape != Shape.OUTSIDE_CORNER_LEFT) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(baseLeftShape, direction));
            }
            if (shape != Shape.OUTSIDE_CORNER_RIGHT) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(baseRightShape, direction));
            }
            VoxelShape cornerShape = switch (shape) {
                case Shape.INSIDE_CORNER_LEFT -> insideCornerLeftShape;
                case Shape.INSIDE_CORNER_RIGHT -> insideCornerRightShape;
                default -> Shapes.m_83040_();
            };
            shapes.add(VoxelShapeHelper.rotateHorizontally(cornerShape, direction));
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state != null ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, (LevelAccessor)context.m_43725_(), context.m_8083_()))) : null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHAPE});
    }

    public Shape getShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction behind;
        Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
        Direction front = this.getCabinetryDirection(level, pos, ((Direction)state.m_61143_((Property)DIRECTION)).m_122424_());
        if (front != null) {
            if (front == facing.m_122427_()) {
                return Shape.INSIDE_CORNER_RIGHT;
            }
            if (front == facing.m_122428_()) {
                return Shape.INSIDE_CORNER_LEFT;
            }
        }
        if ((behind = this.getCabinetryDirection(level, pos, (Direction)state.m_61143_((Property)DIRECTION))) != null) {
            if (behind == facing.m_122427_()) {
                return Shape.OUTSIDE_CORNER_LEFT;
            }
            if (behind == facing.m_122428_()) {
                return Shape.OUTSIDE_CORNER_RIGHT;
            }
        }
        return Shape.DEFAULT;
    }

    public Direction getCabinetryDirection(LevelAccessor level, BlockPos pos, Direction side) {
        Direction direction;
        BlockState relativeState = level.m_8055_(pos.m_121945_(side));
        Block block = relativeState.m_60734_();
        if (block instanceof IKitchenCabinetry) {
            IKitchenCabinetry cabinetry = (IKitchenCabinetry)block;
            direction = cabinetry.getDirection(relativeState);
        } else {
            direction = null;
        }
        return direction;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)DIRECTION);
    }

    public static enum Shape implements StringRepresentable
    {
        DEFAULT("default"),
        INSIDE_CORNER_LEFT("inside_corner_left"),
        INSIDE_CORNER_RIGHT("inside_corner_right"),
        OUTSIDE_CORNER_LEFT("outside_corner_left"),
        OUTSIDE_CORNER_RIGHT("outside_corner_right");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

