/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.ProcessingContainerBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ToasterBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToasterBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<ToasterBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MetalType.CODEC.fieldOf("metal_type").forGetter(block -> block.type), (App)ToasterBlock.m_305607_()).apply((Applicative)builder, ToasterBlock::new));
    private final MetalType type;

    public ToasterBlock(MetalType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    protected MapCodec<ToasterBlock> m_304657_() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)7.0, (double)14.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.rotateHorizontally(baseShape, (Direction)state.m_61143_((Property)DIRECTION)))));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Vec3 clickVec = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)pos));
        Direction forward = context.m_8125_();
        Direction right = forward.m_122427_();
        double side = right.m_122434_().m_6150_(clickVec.f_82479_, 0.0, clickVec.f_82481_);
        side = Math.abs((double)Math.min(right.m_122421_().m_122540_(), 0) + side);
        forward = side < 0.5 ? forward : forward.m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)forward);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ToasterBlockEntity) {
            ToasterBlockEntity toaster = (ToasterBlockEntity)blockEntity;
            if (!level.m_5776_()) {
                boolean hitLever;
                ItemStack heldItem = player.m_21120_(hand);
                Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
                boolean bl = hitLever = result.m_82434_() == facing.m_122428_();
                if (player.m_6047_() || hitLever ? toaster.toggleHeating() : toaster.insertItem(heldItem)) {
                    return InteractionResult.CONSUME;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbourPos, boolean piston) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && level.m_276867_(pos) && (blockEntity = level.m_7702_(pos)) instanceof ToasterBlockEntity) {
            ToasterBlockEntity toaster = (ToasterBlockEntity)blockEntity;
            toaster.startHeating();
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ToasterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return ToasterBlock.createTicker(type, (BlockEntityType)ModBlockEntities.TOASTER.get(), ToasterBlockEntity::clientTick);
        }
        return ToasterBlock.createTicker(type, (BlockEntityType)ModBlockEntities.TOASTER.get(), ProcessingContainerBlockEntity::serverTick);
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_, BlockTags.f_144286_);
    }
}

