/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.StorageCabinetBlock;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WoodenStorageCabinetBlock
extends StorageCabinetBlock
implements BlockTagSupplier {
    private static final MapCodec<WoodenStorageCabinetBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.f_303492_.fieldOf("wood_type").forGetter(block -> block.type), (App)WoodenStorageCabinetBlock.m_305607_()).apply((Applicative)builder, WoodenStorageCabinetBlock::new));
    private final WoodType type;

    public WoodenStorageCabinetBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<WoodenStorageCabinetBlock> m_304657_() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape openShape = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape leftDoorShape = Block.m_49796_((double)-14.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
        VoxelShape rightDoorShape = Block.m_49796_((double)-14.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(VoxelShapeHelper.rotateHorizontally(open ? openShape : baseShape, (Direction)state.m_61143_((Property)DIRECTION)));
            if (open) {
                VoxelShape door = state.m_61143_((Property)HINGE) == DoorHingeSide.LEFT ? leftDoorShape : rightDoorShape;
                shapes.add(VoxelShapeHelper.rotateHorizontally(door, (Direction)state.m_61143_((Property)DIRECTION)));
            }
            return VoxelShapeHelper.combine(shapes);
        })));
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144280_);
    }
}

