/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ToiletBlockEntity
extends BlockEntity
implements IFluidContainerBlock {
    protected final FluidContainer tank;

    public ToiletBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.TOILET.get(), pos, state);
    }

    public ToiletBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.toilet.fluidCapacity.get(), container -> {
            this.m_6596_();
            container.sync(this);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        Level level = Objects.requireNonNull(this.f_58857_);
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item == Items.f_42590_ && !this.tank.isEmpty() && this.tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_)) {
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)heldItem, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            player.m_9236_().m_5594_(null, this.f_58858_, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.m_9236_().m_142346_(null, GameEvent.f_157816_, this.f_58858_);
            return InteractionResult.SUCCESS;
        }
        if (!Services.FLUID.isFluidContainerItem(heldItem)) {
            Vec3 hit = result.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_));
            if (hit.m_7098_() > 0.625) {
                if (!this.tank.isEmpty() && this.flushItems(level) != InteractionResult.PASS) {
                    return InteractionResult.SUCCESS;
                }
                if (((Boolean)Config.SERVER.toilet.dispenseWater.get()).booleanValue() && this.fillWithWater(level) != InteractionResult.PASS) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.m_58904_(), this.m_58899_(), result.m_82434_());
    }

    private InteractionResult fillWithWater(Level level) {
        if (this.tank.isEmpty() || this.tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_)) {
            SoundEvent event;
            if (this.tank.getStoredAmount() < this.tank.getCapacity()) {
                this.tank.push((Fluid)Fluids.f_76193_, FluidContainer.BUCKET_CAPACITY, false);
            }
            if ((event = Services.FLUID.getBucketEmptySound((Fluid)Fluids.f_76193_)) != null) {
                Vec3 splashPos = Vec3.m_82512_((Vec3i)this.f_58858_);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123769_, splashPos.f_82479_, splashPos.f_82480_, splashPos.f_82481_, 10, 0.0, 0.0, 0.0, 0.0);
                level.m_247517_(null, this.f_58858_, event, SoundSource.BLOCKS);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76195_) && this.tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && this.tank.getStoredFluid().m_6212_((Fluid)Fluids.f_76195_)) {
            Pair<Fluid, Long> drained = this.tank.pull(FluidContainer.BUCKET_CAPACITY, true);
            if ((Long)drained.right() != FluidContainer.BUCKET_CAPACITY) {
                return InteractionResult.PASS;
            }
            this.tank.pull(FluidContainer.BUCKET_CAPACITY, false);
            Vec3 pos = Vec3.m_82512_((Vec3i)this.f_58858_);
            ItemEntity entity = new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, new ItemStack((ItemLike)Blocks.f_50080_));
            entity.m_32060_();
            level.m_7967_((Entity)entity);
            level.m_247517_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS);
            level.m_46796_(1501, this.f_58858_, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult flushItems(Level level) {
        List entities = level.m_45976_(ItemEntity.class, new AABB(this.f_58858_));
        entities.forEach(entity -> {
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageFlushItem(entity.m_19879_(), this.f_58858_));
            entity.m_146870_();
        });
        if (!entities.isEmpty()) {
            level.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 40);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.load(tag.m_128469_("FluidTank"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag tankTag = new CompoundTag();
        this.tank.save(tankTag);
        tag.m_128365_("FluidTank", (Tag)tankTag);
    }
}

