/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.ElectricBlockEntityRenderer;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import com.mrcrayfish.furniture.refurbished.electricity.LinkHitResult;
import com.mrcrayfish.furniture.refurbished.electricity.NodeHitResult;
import com.mrcrayfish.furniture.refurbished.item.WrenchItem;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Intersectiond;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class LinkHandler {
    private static final ResourceLocation POWERABLE_AREA = new ResourceLocation("refurbished_furniture", "textures/misc/powerable_area.png");
    private static final ResourceLocation UNPOWERABLE_AREA = new ResourceLocation("refurbished_furniture", "textures/misc/unpowerable_area.png");
    private static final int DEFAULT_LINK_COLOUR = -1;
    private static final int SUCCESS_LINK_COLOUR = -4849844;
    private static final int ERROR_LINK_COLOUR = -3983818;
    private static final double NEAR_DISTANCE = 10.0;
    private static LinkHandler instance;
    @Nullable
    private BlockPos lastNodePos;
    private HitResult result;
    private double linkLength;
    private boolean linkInsideArea;
    private final Set<BlockPos> sourcePositions = new HashSet<BlockPos>();
    private final Set<BlockPos> lastSourcePositions = new HashSet<BlockPos>();
    private VoxelShape cachedPowerableAreaShape;

    public static LinkHandler get() {
        if (instance == null) {
            instance = new LinkHandler();
        }
        return instance;
    }

    private LinkHandler() {
        FrameworkConfigEvents.RELOAD.register((IFrameworkEvent)((FrameworkConfigEvents.Reload)object -> {
            if (object == Config.SERVER) {
                this.lastSourcePositions.clear();
                this.cachedPowerableAreaShape = null;
            }
        }));
    }

    public void setLinkingNode(BlockPos pos) {
        this.lastNodePos = pos;
    }

    public boolean isLinkingNode(IElectricityNode node) {
        return this.lastNodePos != null && this.lastNodePos.equals((Object)node.getNodePosition());
    }

    public boolean isLinking() {
        return this.lastNodePos != null;
    }

    public boolean isLinkInsidePowerableArea() {
        return this.linkInsideArea;
    }

    @Nullable
    public IElectricityNode getLinkingNode(Level level) {
        if (this.lastNodePos == null) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(this.lastNodePos);
        if (blockEntity instanceof IElectricityNode) {
            IElectricityNode node = (IElectricityNode)blockEntity;
            return node;
        }
        return null;
    }

    public double getLinkLength() {
        return this.lastNodePos != null ? this.linkLength : 0.0;
    }

    public void beforeRender(float partialTick) {
        this.updateHitResult(partialTick);
        this.updatePowerSources();
        this.updateLinkState(partialTick);
    }

    private void updateHitResult(float partialTick) {
        HitResult last = this.result;
        this.result = null;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91073_ != null && mc.f_91072_ != null && mc.f_91074_.m_21205_().m_150930_((Item)ModItems.WRENCH.get())) {
            float range = mc.f_91072_.m_105286_();
            NodeHitResult newResult = WrenchItem.performNodeRaycast((Level)mc.f_91073_, (Player)mc.f_91074_, range, partialTick);
            if (newResult.m_6662_() == HitResult.Type.MISS) {
                newResult = this.performLinkRaycast((Player)mc.f_91074_, partialTick, range);
            }
            if (newResult.m_6662_() != HitResult.Type.MISS) {
                this.playHoverSound(last, newResult, (Player)mc.f_91074_, (Level)mc.f_91073_);
                this.result = newResult;
            }
        }
    }

    private void playHoverSound(@Nullable HitResult oldResult, @Nullable HitResult newResult, Player player, Level level) {
        if ((oldResult == null || !oldResult.equals(newResult)) && newResult instanceof LinkHitResult) {
            if (this.lastNodePos != null) {
                return;
            }
            Vec3 pos = newResult.m_82450_();
            float pitch = 1.0f + 0.05f * level.f_46441_.m_188501_();
            level.m_6263_(player, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.ITEM_WRENCH_HOVER_LINK.get(), SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    private void updatePowerSources() {
        Connection connection;
        this.sourcePositions.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        IElectricityNode linking = this.getLinkingNode((Level)mc.f_91073_);
        this.addSourceNodePositions(this.sourcePositions, this.getLinkingNode((Level)mc.f_91073_));
        IElectricityNode target = this.getTargetNode();
        if (linking != null && !linking.isSourceNode()) {
            if (target != null && target.isSourceNode()) {
                this.sourcePositions.clear();
            }
            if (this.sourcePositions.isEmpty()) {
                this.addSourceNodePositions(this.sourcePositions, target);
            }
        }
        if (linking == null && target == null && (connection = this.getTargetConnection()) != null && connection.isCrossingPowerableZone((Level)mc.f_91073_)) {
            Sets.SetView delta;
            IElectricityNode a = connection.getNodeA((Level)mc.f_91073_);
            IElectricityNode b = connection.getNodeB((Level)mc.f_91073_);
            if (a != null && b != null && !(delta = Sets.symmetricDifference(a.getPowerSources(), b.getPowerSources())).isEmpty()) {
                this.sourcePositions.add((BlockPos)List.copyOf(delta).get(0));
            }
        }
    }

    private void updateLinkState(float partialTick) {
        this.linkInsideArea = false;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (this.sourcePositions.isEmpty()) {
            this.linkInsideArea = true;
        } else if (this.lastNodePos != null) {
            this.linkInsideArea = this.sourcePositions.stream().anyMatch(pos -> {
                AABB box = ISourceNode.createPowerableZone((Level)mc.f_91073_, pos);
                return box.m_82390_(this.lastNodePos.m_252807_()) && box.m_82390_(this.getLinkEnd((Player)mc.f_91074_, partialTick));
            });
        } else {
            HitResult hitResult = this.result;
            if (hitResult instanceof LinkHitResult) {
                LinkHitResult hitResult2 = (LinkHitResult)hitResult;
                Connection connection = hitResult2.getConnection();
                Vec3 start = connection.getPosA().m_252807_();
                Vec3 end = connection.getPosB().m_252807_();
                this.linkInsideArea = this.sourcePositions.stream().anyMatch(pos -> {
                    AABB box = ISourceNode.createPowerableZone((Level)mc.f_91073_, pos);
                    return box.m_82390_(start) && box.m_82390_(end);
                });
            }
        }
    }

    private void addSourceNodePositions(Set<BlockPos> positions, @Nullable IElectricityNode start) {
        if (start == null) {
            return;
        }
        if (start.isSourceNode()) {
            positions.add(start.getNodePosition());
            return;
        }
        int searchLimit = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        IElectricityNode.searchNodes(start, searchLimit, true, node -> !node.isSourceNode(), IElectricityNode::isSourceNode).forEach(node -> positions.add(node.getNodePosition()));
    }

    public boolean isTargetNode(IElectricityNode node) {
        NodeHitResult nodeResult;
        HitResult hitResult = this.result;
        return hitResult instanceof NodeHitResult && (nodeResult = (NodeHitResult)hitResult).getNode() == node;
    }

    @Nullable
    public IElectricityNode getTargetNode() {
        IElectricityNode iElectricityNode;
        HitResult hitResult = this.result;
        if (hitResult instanceof NodeHitResult) {
            NodeHitResult nodeResult = (NodeHitResult)hitResult;
            iElectricityNode = nodeResult.getNode();
        } else {
            iElectricityNode = null;
        }
        return iElectricityNode;
    }

    @Nullable
    public Connection getTargetConnection() {
        Connection connection;
        HitResult hitResult = this.result;
        if (hitResult instanceof LinkHitResult) {
            LinkHitResult linkResult = (LinkHitResult)hitResult;
            connection = linkResult.getConnection();
        } else {
            connection = null;
        }
        return connection;
    }

    public void render(Player player, PoseStack poseStack, MultiBufferSource.BufferSource source, float partialTick) {
        if (!player.m_6084_() || !LinkHandler.isHoldingWrench()) {
            this.lastNodePos = null;
        }
        this.renderPowerableArea(poseStack, player, partialTick);
        if (this.lastNodePos != null) {
            this.renderUnfinishedLink(player, this.lastNodePos, partialTick);
        }
    }

    private void renderUnfinishedLink(Player player, BlockPos pos, float partialTick) {
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        renderer.deferDraw((pose, consumer) -> {
            Vec3 start = Vec3.m_82512_((Vec3i)pos);
            Vec3 end = this.getLinkEnd(player, partialTick);
            Vec3 delta = end.m_82546_(start);
            this.linkLength = delta.m_82553_();
            double yaw = Math.atan2(-delta.f_82481_, delta.f_82479_) + Math.PI;
            double pitch = Math.atan2(delta.m_165924_(), delta.f_82480_) + 1.5707963705062866;
            pose.m_85836_();
            pose.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
            pose.m_252781_(Axis.f_252436_.m_252961_((float)yaw));
            pose.m_252781_(Axis.f_252403_.m_252961_((float)pitch));
            int color = this.getLinkColour(player.m_9236_());
            Matrix4f matrix = pose.m_85850_().m_252922_();
            renderer.drawColouredBox(matrix, (VertexConsumer)consumer, new AABB(0.0, -0.03125, -0.03125, delta.m_82553_(), 0.03125, 0.03125), color, 0.8f);
            renderer.drawColouredBox(matrix, (VertexConsumer)consumer, new AABB(0.0, -0.03125, -0.03125, delta.m_82553_(), 0.03125, 0.03125).m_82400_(0.03125), color, 0.6f);
            pose.m_85849_();
        });
    }

    private Vec3 getLinkEnd(Player player, float partialTick) {
        IElectricityNode node = this.getTargetNode();
        if (node != null && !this.isLinkingNode(node) && this.canLinkToNode(player.m_9236_(), node)) {
            return node.getNodePosition().m_252807_();
        }
        return player.m_20252_(partialTick).m_82541_().m_82490_(1.5).m_82549_(player.m_20299_(partialTick));
    }

    public int getLinkColour(Level level) {
        IElectricityNode linking = this.getLinkingNode(level);
        if (linking == null) {
            return -1;
        }
        if (this.linkLength > 512.0) {
            return -3983818;
        }
        IElectricityNode target = this.getTargetNode();
        if (target != null && !this.isLinkingNode(target)) {
            if (this.canLinkToNode(level, target)) {
                return -4849844;
            }
            return -3983818;
        }
        if (!this.linkInsideArea) {
            return -3983818;
        }
        return -1;
    }

    public boolean canLinkToNode(Level level, IElectricityNode target) {
        IElectricityNode lastNode;
        if (this.lastNodePos != null && (lastNode = this.getLinkingNode(level)) != null && target != null && lastNode != target) {
            if (target.isSourceNode() && lastNode.isSourceNode()) {
                return false;
            }
            if (target.isNodeConnectionLimitReached()) {
                return false;
            }
            return !lastNode.isConnectedToNode(target);
        }
        return false;
    }

    private HitResult performLinkRaycast(Player player, float partialTick, float range) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Connection closestConnection = null;
        Vec3 hit = Vec3.f_82478_;
        Set<Connection> connections = ElectricBlockEntityRenderer.getDrawnConnections();
        for (Connection connection : connections) {
            Vec3 rayStart = player.m_20299_(partialTick);
            Vec3 rayEnd = rayStart.m_82549_(player.m_20252_(partialTick).m_82541_().m_82490_((double)range));
            Vec3 linkStart = connection.getPosA().m_252807_();
            Vec3 linkEnd = connection.getPosB().m_252807_();
            Vector3d result = new Vector3d();
            double squareDistance = Intersectiond.findClosestPointsLineSegments((double)rayStart.f_82479_, (double)rayStart.f_82480_, (double)rayStart.f_82481_, (double)rayEnd.f_82479_, (double)rayEnd.f_82480_, (double)rayEnd.f_82481_, (double)linkStart.f_82479_, (double)linkStart.f_82480_, (double)linkStart.f_82481_, (double)linkEnd.f_82479_, (double)linkEnd.f_82480_, (double)linkEnd.f_82481_, (Vector3d)new Vector3d(), (Vector3d)result);
            double distance = Math.sqrt(squareDistance);
            if (!(distance < 0.1) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestConnection = connection;
            hit = new Vec3(result.x, result.y, result.z);
        }
        return new LinkHitResult(hit, closestConnection);
    }

    public boolean onWrenchLeftClick(Level level) {
        LinkHitResult linkResult;
        Connection connection;
        HitResult hitResult;
        if (!this.isLinking() && (hitResult = this.result) instanceof LinkHitResult && (connection = (linkResult = (LinkHitResult)hitResult).getConnection()) != null) {
            Vec3 hit = linkResult.m_82450_();
            level.m_7785_(hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)ModSounds.ITEM_WRENCH_REMOVE_LINK.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            Network.getPlay().sendToServer((Object)new MessageDeleteLink(connection.getPosA(), connection.getPosB()));
            return true;
        }
        return false;
    }

    @Nullable
    private VoxelShape getPowerableAreaShape() {
        Minecraft mc = Minecraft.m_91087_();
        if (this.sourcePositions.isEmpty() || mc.f_91073_ == null) {
            return null;
        }
        if (this.lastSourcePositions.equals(this.sourcePositions)) {
            return this.cachedPowerableAreaShape;
        }
        this.sourcePositions.stream().map(pos -> ISourceNode.createPowerableZone((Level)mc.f_91073_, pos)).map(aabb -> {
            VoxelShape shape1 = Shapes.m_83064_((AABB)aabb);
            VoxelShape shape2 = Shapes.m_83064_((AABB)aabb.m_82400_(0.001));
            return Pair.of((Object)shape1, (Object)shape2);
        }).reduce((p1, p2) -> {
            VoxelShape shape1 = Shapes.m_83148_((VoxelShape)((VoxelShape)p1.first()), (VoxelShape)((VoxelShape)p2.first()), (BooleanOp)BooleanOp.f_82695_);
            VoxelShape shape2 = Shapes.m_83148_((VoxelShape)((VoxelShape)p1.second()), (VoxelShape)((VoxelShape)p2.second()), (BooleanOp)BooleanOp.f_82695_);
            return Pair.of((Object)shape1, (Object)shape2);
        }).map(pair -> Shapes.m_83148_((VoxelShape)((VoxelShape)pair.first()), (VoxelShape)((VoxelShape)pair.second()), (BooleanOp)BooleanOp.f_82683_)).ifPresent(shape -> {
            this.cachedPowerableAreaShape = shape;
        });
        this.lastSourcePositions.clear();
        this.lastSourcePositions.addAll(this.sourcePositions);
        return this.cachedPowerableAreaShape;
    }

    private void renderPowerableArea(PoseStack poseStack, Player player, float partialTick) {
        float areaAlpha;
        VoxelShape areaShape = this.getPowerableAreaShape();
        if (areaShape == null) {
            return;
        }
        Vec3 eyePos = player.m_20299_(partialTick);
        double nearDistanceSqr = 100.0;
        float f = areaAlpha = !this.linkInsideArea ? 1.0f : areaShape.m_166067_(eyePos).map(vec -> vec.m_82557_(eyePos)).map(val -> Float.valueOf(1.0f - (float)Mth.m_14008_((double)(val / nearDistanceSqr), (double)0.0, (double)1.0))).orElse(Float.valueOf(0.0f)).floatValue();
        if (areaAlpha <= 0.0f) {
            return;
        }
        areaAlpha = 1.0f - (float)Math.pow(1.0f - areaAlpha, 5.0);
        Tesselator tesselator = Tesselator.m_85913_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.linkInsideArea ? POWERABLE_AREA : UNPOWERABLE_AREA));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.6f * areaAlpha));
        RenderSystem.depthMask((boolean)Minecraft.m_91085_());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        areaShape.m_83299_().forEach(box -> this.drawTexturedBox(poseStack, (VertexConsumer)builder, (AABB)box));
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawTexturedBox(PoseStack poseStack, VertexConsumer consumer, AABB box) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float offset = (float)Util.m_137550_() * 0.001f;
        float width = (float)(box.f_82291_ - box.f_82288_);
        float height = (float)(box.f_82292_ - box.f_82289_);
        if ((double)width > 0.01) {
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(0.0f, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(width, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(width, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(0.0f, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(0.0f, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(width, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(width, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(0.0f, offset).m_5752_();
        }
        if ((double)(width = (float)(box.f_82293_ - box.f_82290_)) > 0.01) {
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(0.0f, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(width, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(width, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(0.0f, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(0.0f, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(width, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(width, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(0.0f, offset).m_5752_();
        }
        width = (float)(box.f_82291_ - box.f_82288_);
        height = (float)(box.f_82293_ - box.f_82290_);
        if ((double)width > 0.01) {
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(0.0f, width + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(height, width + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_7421_(height, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_7421_(0.0f, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(0.0f, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_7421_(width, height + offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(width, offset).m_5752_();
            consumer.m_252986_(matrix, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_7421_(0.0f, offset).m_5752_();
        }
    }

    public static boolean isHoldingWrench() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91074_ != null && mc.f_91074_.m_21205_().m_150930_((Item)ModItems.WRENCH.get());
    }
}

