/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWithdrawExperience;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.text.DecimalFormat;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Matrix4f;

public class RecyclingBinScreen
extends ElectricityContainerScreen<RecycleBinMenu> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.###");
    private static final ResourceLocation RECYCLING_BIN_TEXTURE = Utils.resource("textures/gui/container/recycle_bin.png");
    private OnOffSlider slider;
    private Button withdrawButton;

    public RecyclingBinScreen(RecycleBinMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97727_ = 193;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.slider = (OnOffSlider)this.m_142416_((GuiEventListener)new OnOffSlider(this.f_97735_ + this.f_97726_ - 22 - 6, this.f_97736_ + 5, Components.GUI_TOGGLE_POWER, btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
        this.withdrawButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 7, this.f_97736_ + 75, 20, 10, 162, Components.GUI_WITHDRAW_EXPERIENCE, btn -> Network.getPlay().sendToServer((Object)new MessageWithdrawExperience())));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((RecycleBinMenu)this.f_97732_).isEnabled());
        this.withdrawButton.f_93623_ = this.getExperiencePoints() >= 1.0;
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTick, mouseX, mouseY);
        graphics.m_280218_(RECYCLING_BIN_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((RecycleBinMenu)this.f_97732_).getProcessTime() >= 0) {
            int maxProcessTime = (Integer)Config.SERVER.recycleBin.processingTime.get();
            int width = (int)Math.ceil(25.0f * ((float)((RecycleBinMenu)this.f_97732_).getProcessTime() / (float)maxProcessTime));
            graphics.m_280218_(RECYCLING_BIN_TEXTURE, this.f_97735_ + 85, this.f_97736_ + 28, 176, 0, width, 17);
        }
        int maxLevel = (Integer)Config.SERVER.recycleBin.maximumExperienceLevels.get();
        double currentLevel = Mth.m_14008_((double)this.getExperienceLevel(), (double)0.0, (double)maxLevel);
        MutableComponent levelLabel = Utils.translation("gui", "experience_level", FORMAT.format(currentLevel), maxLevel);
        int labelWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)levelLabel) / 2;
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        this.f_96541_.f_91062_.m_168645_(levelLabel.m_7532_(), (float)(this.f_97735_ + 68 - labelWidth), (float)(this.f_97736_ + 60), -3604593, -13819646, matrix, (MultiBufferSource)graphics.m_280091_(), 0xF000F0);
        this.drawExperienceFluid(graphics, (float)(currentLevel / (double)maxLevel));
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.f_97735_ + 118, this.f_97736_ + 22, 32, 48)) {
            this.m_257404_((Component)Utils.translation("gui", "experience_points", (int)this.getExperiencePoints()));
        }
    }

    private double getExperiencePoints() {
        return (double)((RecycleBinMenu)this.f_97732_).getRecycledCount() * (Double)Config.SERVER.recycleBin.experiencePerItem.get();
    }

    private double getExperienceLevel() {
        double points = this.getExperiencePoints();
        if (points <= 352.0) {
            return Math.sqrt(points + 9.0) - 3.0;
        }
        if (points <= 1507.0) {
            return 8.1 + Math.sqrt(0.4 * (points - 195.975));
        }
        return 18.055555555555557 + Math.sqrt(0.2222222222222222 * (points - 752.9861111111111));
    }

    private void drawExperienceFluid(GuiGraphics graphics, float amount) {
        int yOffset = 48 - (int)(48.0f * amount);
        int height = (int)(48.0f * amount);
        float animation = (Mth.m_14031_((float)((float)Util.m_137550_() / 500.0f)) + 1.0f) / 2.0f;
        this.drawBlitWithAlpha(graphics, this.f_97735_ + 118, this.f_97736_ + 22 + yOffset, 176, 17, 32, height, animation);
        this.drawBlitWithAlpha(graphics, this.f_97735_ + 118, this.f_97736_ + 22 + yOffset, 208, 17, 32, height, 1.0f - animation);
    }

    private void drawBlitWithAlpha(GuiGraphics graphics, int x, int y, int u, int v, int width, int height, float alpha) {
        float scale = 0.00390625f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RECYCLING_BIN_TEXTURE);
        RenderSystem.setShader(GameRenderer::m_172814_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        builder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)u * scale, (float)v * scale).m_5752_();
        builder.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)u * scale, (float)(v + height) * scale).m_5752_();
        builder.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)(u + width) * scale, (float)(v + height) * scale).m_5752_();
        builder.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)(u + width) * scale, (float)v * scale).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }
}

