/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.gui.ClientWorkbenchRecipeIngredientTooltip;
import com.mrcrayfish.furniture.refurbished.client.gui.ClientWorkbenchRecipeTooltip;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class WorkbenchScreen
extends ElectricityContainerScreen<WorkbenchMenu> {
    public static final ResourceLocation WORKBENCH_TEXTURE = Utils.resource("textures/gui/container/workbench.png");
    public static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("recipe_book/filter_enabled"), new ResourceLocation("recipe_book/filter_disabled"), new ResourceLocation("recipe_book/filter_enabled_highlighted"), new ResourceLocation("recipe_book/filter_disabled_highlighted"));
    public static final WidgetSprites SEARCH_NEIGHBOURS_SPRITES = new WidgetSprites(Utils.resource("search_neighbours_selected"), Utils.resource("search_neighbours_unselected"), Utils.resource("search_neighbours_selected_focused"), Utils.resource("search_neighbours_unselected_focused"));
    private static final int BUTTON_SIZE = 20;
    private static final int RECIPES_PER_ROW = 6;
    private static final int WINDOW_WIDTH = 120;
    private static final int WINDOW_HEIGHT = 88;
    private static final int SCROLL_SPEED = 10;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int SCROLLBAR_AREA = 106;
    private static final Category CATEGORY_ALL = new Category(new TagKey[0]);
    private static final Category CATEGORY_GENERAL = new Category(ModTags.Items.GENERAL, ModTags.Items.BEDROOM);
    private static final Category CATEGORY_KITCHEN = new Category(ModTags.Items.KITCHEN);
    private static final Category CATEGORY_OUTDOORS = new Category(ModTags.Items.OUTDOORS);
    private static final Category CATEGORY_BATHROOM = new Category(ModTags.Items.BATHROOM);
    private static final Category CATEGORY_ELECTRONICS = new Category(ModTags.Items.ELECTRONICS);
    private static final List<Category> CATEGORIES = List.of(CATEGORY_ALL, CATEGORY_GENERAL, CATEGORY_KITCHEN, CATEGORY_OUTDOORS, CATEGORY_BATHROOM, CATEGORY_ELECTRONICS);
    private static boolean craftableOnly;
    protected final Map<ResourceLocation, Integer> recipeToIndex;
    protected final List<RecipeHolder<WorkbenchContructingRecipe>> displayRecipes = new ArrayList<RecipeHolder<WorkbenchContructingRecipe>>();
    protected StateSwitchingButton craftableOnlyButton;
    protected StateSwitchingButton searchNeighboursButton;
    protected double scroll;
    protected int hoveredIndex = -1;
    protected int clickedY = -1;

    public WorkbenchScreen(WorkbenchMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 216;
        this.f_97727_ = 229;
        this.f_97730_ = 28;
        this.f_97731_ = this.f_97727_ - 94;
        ((WorkbenchMenu)this.f_97732_).setUpdateCallback(this::updateRecipes);
        this.recipeToIndex = (Map)Util.m_137537_(() -> {
            HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
            List<RecipeHolder<WorkbenchContructingRecipe>> recipes = menu.getRecipes();
            for (int i = 0; i < recipes.size(); ++i) {
                map.put(recipes.get(i).f_291676_(), i);
            }
            return ImmutableMap.copyOf(map);
        });
        this.updateRecipes();
        this.scrollToSelected();
    }

    private void updateRecipes() {
        this.displayRecipes.clear();
        Category selectedCategory = CATEGORIES.stream().filter(Category::isEnabled).findFirst().orElse(CATEGORY_ALL);
        for (RecipeHolder<WorkbenchContructingRecipe> holder2 : ((WorkbenchMenu)this.f_97732_).getRecipes()) {
            if (!selectedCategory.in(((WorkbenchContructingRecipe)holder2.f_291008_()).getResult()) || craftableOnly && !((WorkbenchMenu)this.f_97732_).canCraft(holder2)) continue;
            this.displayRecipes.add(holder2);
        }
        this.displayRecipes.sort(Comparator.comparing(holder -> ((WorkbenchContructingRecipe)holder.f_291008_()).getResultId()));
    }

    @Override
    protected int getBannerTop() {
        return this.f_97736_ + 52;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.craftableOnlyButton = (StateSwitchingButton)this.m_142416_((GuiEventListener)new CraftableButton(this.f_97735_ + 184, this.f_97736_ + 44, 26, 16, craftableOnly));
        this.craftableOnlyButton.m_94624_(FILTER_BUTTON_SPRITES);
        this.searchNeighboursButton = (StateSwitchingButton)this.m_142416_((GuiEventListener)new SearchNeighboursButton(this.f_97735_ + 184, this.f_97736_ + 62, 26, 16, ((WorkbenchMenu)this.f_97732_).shouldSearchNeighbours()));
        this.searchNeighboursButton.m_94624_(SEARCH_NEIGHBOURS_SPRITES);
        this.m_142416_((GuiEventListener)new CategoryButton(this.f_97735_ + 46, this.f_97736_ + 108, 236, 55, CATEGORY_ALL));
        this.m_142416_((GuiEventListener)new CategoryButton(this.f_97735_ + 66, this.f_97736_ + 108, 236, 69, CATEGORY_GENERAL));
        this.m_142416_((GuiEventListener)new CategoryButton(this.f_97735_ + 86, this.f_97736_ + 108, 236, 83, CATEGORY_KITCHEN));
        this.m_142416_((GuiEventListener)new CategoryButton(this.f_97735_ + 106, this.f_97736_ + 108, 236, 97, CATEGORY_OUTDOORS));
        this.m_142416_((GuiEventListener)new CategoryButton(this.f_97735_ + 126, this.f_97736_ + 108, 236, 111, CATEGORY_BATHROOM));
        this.m_142416_((GuiEventListener)new CategoryButton(this.f_97735_ + 146, this.f_97736_ + 108, 236, 125, CATEGORY_ELECTRONICS));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.searchNeighboursButton.m_94635_(((WorkbenchMenu)this.f_97732_).shouldSearchNeighbours());
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
        if (((WorkbenchMenu)this.f_97732_).isPowered() && this.hoveredIndex != -1) {
            this.renderRecipeTooltip(graphics, mouseX, mouseY, this.hoveredIndex);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(WORKBENCH_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderScrollbar(graphics, mouseY);
        this.renderRecipes(graphics, partialTick, mouseX, mouseY);
        this.renderOverlay(graphics);
        super.m_7286_(graphics, partialTick, mouseX, mouseY);
        if (this.m_6774_(199, 5, 10, 10, mouseX, mouseY)) {
            this.m_257959_(ScreenHelper.createMultilineTooltip(List.of(Utils.translation("gui", "how_to", new Object[0]).m_130940_(ChatFormatting.GOLD), Utils.translation("gui", "workbench_info", new Object[0]))).m_257408_(this.f_96541_));
        }
    }

    private void renderScrollbar(GuiGraphics graphics, int mouseY) {
        int textureU = this.getMaxScroll() > 0 ? 216 : 228;
        graphics.m_280218_(WORKBENCH_TEXTURE, this.f_97735_ + 169, this.f_97736_ + 18 + this.getScrollbarPosition(mouseY), textureU, 40, 12, 15);
    }

    private void renderRecipes(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.hoveredIndex = -1;
        graphics.m_280588_(this.f_97735_ + 46, this.f_97736_ + 18, this.f_97735_ + 46 + 120, this.f_97736_ + 18 + 88);
        List<RecipeHolder<WorkbenchContructingRecipe>> recipes = this.displayRecipes;
        double scroll = this.getScrollAmount(mouseY);
        int startIndex = (int)(scroll / 20.0) * 6;
        int endIndex = startIndex + Mth.m_14165_((double)5.4) * 6;
        boolean mouseInWindow = ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.f_97735_ + 46, this.f_97736_ + 18, 120, 88);
        for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
            RecipeHolder<WorkbenchContructingRecipe> recipe = recipes.get(i);
            int recipeIndex = this.recipeToIndex.get(recipe.f_291676_());
            boolean canCraft = ((WorkbenchMenu)this.f_97732_).canCraft(recipe);
            boolean selected = recipeIndex == ((WorkbenchMenu)this.f_97732_).getSelectedRecipeIndex();
            int buttonX = this.f_97735_ + 46 + i % 6 * 20;
            int buttonY = this.f_97736_ + 18 + i / 6 * 20 - (int)scroll;
            int textureU = 216 + (!canCraft ? 20 : 0);
            int textureV = selected ? 20 : 0;
            graphics.m_280218_(WORKBENCH_TEXTURE, buttonX, buttonY, textureU, textureV, 20, 20);
            graphics.m_280203_(((WorkbenchContructingRecipe)recipe.f_291008_()).m_8043_(((WorkbenchMenu)this.f_97732_).getLevel().m_9598_()), buttonX + 2, buttonY + 2);
            if (!mouseInWindow || !ScreenHelper.isMouseWithinBounds(mouseX, mouseY, buttonX, buttonY, 20, 20)) continue;
            this.hoveredIndex = recipeIndex;
        }
        graphics.m_280618_();
    }

    private void renderOverlay(GuiGraphics graphics) {
        if (!((WorkbenchMenu)this.f_97732_).isPowered()) {
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 200.0f);
            graphics.m_280509_(this.f_97735_ + 46, this.f_97736_ + 18, this.f_97735_ + 46 + 120, this.f_97736_ + 18 + 88, -1442840576);
            pose.m_85849_();
        }
    }

    private void renderRecipeTooltip(GuiGraphics graphics, int mouseX, int mouseY, int recipeIndex) {
        RecipeHolder<WorkbenchContructingRecipe> holder = ((WorkbenchMenu)this.f_97732_).getRecipes().get(recipeIndex);
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        components.add((ClientTooltipComponent)new ClientTextTooltip(((WorkbenchContructingRecipe)holder.f_291008_()).m_8043_(((WorkbenchMenu)this.f_97732_).getLevel().m_9598_()).m_41786_().m_7532_()));
        if (!Screen.m_96638_()) {
            components.add(new ClientWorkbenchRecipeTooltip((WorkbenchMenu)this.f_97732_, (WorkbenchContructingRecipe)holder.f_291008_()));
            components.add((ClientTooltipComponent)new ClientTextTooltip(Components.GUI_HOLD_SHIFT_DETAILS.m_7532_()));
        } else {
            HashMap counted = new HashMap();
            ((WorkbenchContructingRecipe)holder.f_291008_()).getMaterials().forEach(material -> components.add(new ClientWorkbenchRecipeIngredientTooltip((WorkbenchMenu)this.f_97732_, (StackedIngredient)material, counted)));
        }
        ClientServices.PLATFORM.renderTooltip(graphics, this.f_96547_, components, mouseX, mouseY, DefaultTooltipPositioner.f_262752_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (((WorkbenchMenu)this.f_97732_).isPowered() && this.hoveredIndex != -1 && this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
                Network.getPlay().sendToServer((Object)new MessageWorkbench.SelectRecipe(this.hoveredIndex));
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.f_97735_ + 169, this.f_97736_ + 18 + this.getScrollbarPosition((int)mouseY), 12, 15)) {
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY != -1) {
            this.scroll = this.getScrollAmount((int)mouseY);
            this.clickedY = -1;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.clickedY == -1 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.f_97735_ + 46, this.f_97736_ + 18, 135, 88)) {
            this.scroll = Mth.m_14008_((double)(this.scroll - deltaY * 10.0), (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaX, deltaY);
    }

    private void updateScroll() {
        this.scroll = Mth.m_14008_((double)this.scroll, (double)0.0, (double)this.getMaxScroll());
    }

    private double getScrollAmount(int mouseY) {
        return Mth.m_14008_((double)(this.scroll + (double)this.getScrollbarDelta(mouseY)), (double)0.0, (double)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return !((WorkbenchMenu)this.f_97732_).isPowered() ? 0 : Math.max(0, (int)(Math.ceil((double)this.displayRecipes.size() / 6.0) * 20.0) - 88);
    }

    private int getScrollbarPosition(int mouseY) {
        return (int)(this.getScrollAmount(mouseY) / (double)this.getMaxScroll() * 91.0);
    }

    private int getScrollbarDelta(int mouseY) {
        double scrollPerUnit = (double)this.getMaxScroll() / 91.0;
        return this.clickedY != -1 ? (int)((double)(mouseY - this.clickedY) * scrollPerUnit) : 0;
    }

    private void scrollToSelected() {
        int selectedIndex = ((WorkbenchMenu)this.f_97732_).getSelectedRecipeIndex();
        if (selectedIndex >= 0 && selectedIndex < this.displayRecipes.size()) {
            int newScroll = selectedIndex / 6 * 20;
            this.scroll = Mth.m_14045_((int)(newScroll -= 34), (int)0, (int)this.getMaxScroll());
        }
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        if (listener == this.craftableOnlyButton || listener == this.searchNeighboursButton) {
            return;
        }
        super.m_7522_(listener);
    }

    public static class Category {
        private final TagKey<Item>[] tags;
        private boolean enabled;

        @SafeVarargs
        private Category(TagKey<Item> ... tags) {
            this.tags = tags;
            this.enabled = tags.length == 0;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean in(ItemStack result) {
            if (this.tags.length == 0) {
                return true;
            }
            for (TagKey<Item> tag : this.tags) {
                if (!result.m_204117_(tag)) continue;
                return true;
            }
            return false;
        }
    }

    private class CraftableButton
    extends StateSwitchingButton {
        private static final Component VANILLA_ONLY_CRAFTABLE = Component.m_237115_((String)"gui.recipebook.toggleRecipes.craftable");
        private static final Component VANILLA_ALL_RECIPES = Component.m_237115_((String)"gui.recipebook.toggleRecipes.all");

        public CraftableButton(int x, int y, int width, int height, boolean state) {
            super(x, y, width, height, state);
            this.updateTooltip();
        }

        public void m_5716_(double mouseX, double mouseY) {
            craftableOnly = this.f_94609_ = !this.f_94609_;
            WorkbenchScreen.this.updateRecipes();
            this.updateTooltip();
        }

        private void updateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)(this.f_94609_ ? VANILLA_ONLY_CRAFTABLE : VANILLA_ALL_RECIPES)));
        }
    }

    private static class SearchNeighboursButton
    extends StateSwitchingButton {
        private static final Component SEARCH_NEIGHBOURS_OFF = Utils.translation("gui", "workbench.search_neighbours.off", new Object[0]);
        private static final Component SEARCH_NEIGHBOURS_ON = Utils.translation("gui", "workbench.search_neighbours.on", new Object[0]);

        public SearchNeighboursButton(int x, int y, int width, int height, boolean state) {
            super(x, y, width, height, state);
            this.updateTooltip();
        }

        public void m_5716_(double mouseX, double mouseY) {
            Network.getPlay().sendToServer((Object)new MessageWorkbench.SearchNeighbours());
        }

        public void m_94635_(boolean state) {
            boolean original = this.m_94620_();
            super.m_94635_(state);
            if (original != state) {
                this.updateTooltip();
            }
        }

        private void updateTooltip() {
            this.m_257544_(Tooltip.m_257550_((Component)(this.f_94609_ ? SEARCH_NEIGHBOURS_ON : SEARCH_NEIGHBOURS_OFF)));
        }
    }

    public class CategoryButton
    extends Button {
        private final int iconU;
        private final int iconV;
        private final Category category;

        protected CategoryButton(int x, int y, int iconU, int iconV, Category category) {
            super(x, y, 20, 16, CommonComponents.f_237098_, btn -> ((CategoryButton)btn).toggle(), f_252438_);
            this.iconU = iconU;
            this.iconV = iconV;
            this.category = category;
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (this.category.tags.length > 0) {
                ResourceLocation tagId = this.category.tags[0].f_203868_();
                String tooltipTitle = String.format("filterCategory.%s.%s", tagId.m_135827_(), tagId.m_135815_().replace("/", "."));
                String tooltipDesc = tooltipTitle + ".desc";
                this.m_257544_(ScreenHelper.createMultilineTooltip(List.of(Component.m_237115_((String)tooltipTitle), Component.m_237115_((String)tooltipDesc).m_130940_(ChatFormatting.GRAY))));
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)Components.GUI_SHOW_ALL_CATEGORIES));
            }
        }

        private void toggle() {
            CATEGORIES.forEach(c -> c.setEnabled(false));
            this.category.enabled = true;
            WorkbenchScreen.this.updateRecipes();
            WorkbenchScreen.this.updateScroll();
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int textureV = this.f_93622_ ? 87 : (this.category.enabled ? 71 : 55);
            graphics.m_280218_(WORKBENCH_TEXTURE, this.m_252754_(), this.m_252907_(), 216, textureV, 20, 16);
            graphics.m_280218_(WORKBENCH_TEXTURE, this.m_252754_() + 3, this.m_252907_() + 1, this.iconU, this.iconV, 14, 14);
        }
    }
}

