/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CuttingBoardCombiningRecipe
implements Recipe<Container> {
    public static final int MAX_INGREDIENTS = 5;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;

    public CuttingBoardCombiningRecipe(NonNullList<Ingredient> ingredients, ItemStack result) {
        this.ingredients = ingredients;
        this.result = result;
    }

    public boolean m_5818_(Container container, Level level) {
        for (int i = 0; i < this.ingredients.size() && i < container.m_6643_(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean completelyMatches(Container container) {
        if (this.ingredients.size() <= container.m_6643_()) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(container.m_8020_(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Builder
    implements RecipeBuilder {
        private final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
        private final ItemStack result;

        public Builder(ItemStack output) {
            this.result = output;
        }

        public Builder add(Ingredient ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public RecipeBuilder m_126132_(String name, Criterion<?> criterion) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support unlocking");
        }

        public RecipeBuilder m_126145_(@Nullable String group) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support setting the group");
        }

        public Item m_142372_() {
            return this.result.m_41720_();
        }

        public void m_126140_(RecipeOutput output, ResourceLocation id) {
            this.validate();
            output.m_292927_(id, (Recipe)new CuttingBoardCombiningRecipe(this.ingredients, this.result), null);
        }

        private void validate() {
            if (this.ingredients.size() < 2) {
                throw new IllegalStateException("Cutting Board combining recipe must have at least 2 input ingredients");
            }
            if (this.ingredients.size() > 5) {
                throw new IllegalStateException("Cutting Board combining recipe only supports up to 5 input ingredients");
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<CuttingBoardCombiningRecipe> {
        public static final Codec<CuttingBoardCombiningRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] inputs = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.m_43947_()).toArray(Ingredient[]::new);
            if (inputs.length > 5) {
                return DataResult.error(() -> "Too many ingredients");
            }
            if (inputs.length == 0) {
                return DataResult.error(() -> "No ingredients");
            }
            return DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputs));
        }, DataResult::success).forGetter(recipe -> recipe.m_7527_()), (App)ItemStack.f_302323_.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, CuttingBoardCombiningRecipe::new));

        public Codec<CuttingBoardCombiningRecipe> m_292673_() {
            return CODEC;
        }

        public CuttingBoardCombiningRecipe fromNetwork(FriendlyByteBuf buffer) {
            int ingredientCount = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            IntStream.range(0, ingredientCount).forEach(i -> ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer)));
            ItemStack result = buffer.m_130267_();
            return new CuttingBoardCombiningRecipe((NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, CuttingBoardCombiningRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
        }
    }
}

