/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record StackedIngredient(Ingredient ingredient, int count) {
    public static final StackedIngredient EMPTY = new StackedIngredient(Ingredient.f_43901_, 0);
    public static final Codec<StackedIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(o -> o.ingredient), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(o -> o.count)).apply((Applicative)builder, StackedIngredient::new));

    public static StackedIngredient fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int count = buffer.readInt();
        return new StackedIngredient(ingredient, count);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeInt(this.count);
    }

    public static StackedIngredient of(TagKey<Item> tag, int count) {
        return new StackedIngredient(Ingredient.m_204132_(tag), count);
    }

    public static StackedIngredient of(ItemStack stack) {
        return new StackedIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_());
    }

    public static StackedIngredient of(Ingredient ingredient, int count) {
        return new StackedIngredient(ingredient, count);
    }
}

