/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.data.Material;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WorkbenchContructingRecipe
implements Recipe<Container> {
    private final NonNullList<StackedIngredient> materials;
    private final ItemStack result;
    private final boolean notification;

    public WorkbenchContructingRecipe(NonNullList<StackedIngredient> materials, ItemStack result, boolean notification) {
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.WORKBENCH_RECIPE.get();
    }

    public boolean m_5818_(Container container, Level level) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public boolean m_271738_() {
        return this.notification;
    }

    public NonNullList<StackedIngredient> getMaterials() {
        return this.materials;
    }

    public int getResultId() {
        return Item.m_41393_((Item)this.result.m_41720_());
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static Builder builder(ItemLike result, int count, Function<ItemLike, Criterion<?>> hasItem, Function<TagKey<Item>, Criterion<?>> hasTag) {
        return new Builder(result.m_5456_(), count, hasItem, hasTag);
    }

    public static class Builder
    implements RecipeBuilder {
        private final Item result;
        private final int count;
        private final Function<ItemLike, Criterion<?>> hasItem;
        private final Function<TagKey<Item>, Criterion<?>> hasTag;
        private final NonNullList<StackedIngredient> materials = NonNullList.m_122779_();
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
        private RecipeCategory category = RecipeCategory.MISC;
        private boolean showNotification;

        private Builder(Item result, int count, Function<ItemLike, Criterion<?>> hasItem, Function<TagKey<Item>, Criterion<?>> hasTag) {
            this.result = result;
            this.count = count;
            this.hasItem = hasItem;
            this.hasTag = hasTag;
        }

        public Builder requiresMaterial(Material<?> material) {
            this.materials.add((Object)material.asStackedIngredient());
            return this.unlockedBy("has_" + material.getName(), material.createTrigger(this.hasItem, this.hasTag));
        }

        public Builder unlockedBy(String name, Criterion<?> trigger) {
            this.criteria.put(name, trigger);
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Builder category(RecipeCategory category) {
            this.category = category;
            return this;
        }

        public Builder showNotification(boolean show) {
            this.showNotification = show;
            return this;
        }

        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(RecipeOutput output, ResourceLocation id) {
            this.validate(id);
            Advancement.Builder builder = output.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).m_138383_(arg_0, arg_1));
            output.m_292927_(id, (Recipe)new WorkbenchContructingRecipe(this.materials, new ItemStack((ItemLike)this.result), this.showNotification), builder.m_138403_(id.m_246208_("recipes/" + this.category.m_247710_() + "/")));
        }

        private void validate(ResourceLocation id) {
            if (this.materials.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one material for workbench crafting recipe %s".formatted(id));
            }
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<WorkbenchContructingRecipe> {
        public static final Codec<WorkbenchContructingRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)StackedIngredient.CODEC.listOf().fieldOf("materials").flatXmap(materials -> {
            Object[] inputs = (StackedIngredient[])materials.stream().filter(ingredient -> !ingredient.ingredient().m_43947_() || ingredient.count() <= 0).toArray(StackedIngredient[]::new);
            return DataResult.success((Object)NonNullList.m_122783_((Object)StackedIngredient.EMPTY, (Object[])inputs));
        }, DataResult::success).forGetter(o -> o.materials), (App)ItemStack.f_302323_.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)false).forGetter(recipe -> recipe.notification)).apply((Applicative)builder, WorkbenchContructingRecipe::new));

        public Codec<WorkbenchContructingRecipe> m_292673_() {
            return CODEC;
        }

        public WorkbenchContructingRecipe fromNetwork(FriendlyByteBuf buffer) {
            int materialCount = buffer.readInt();
            NonNullList materials = NonNullList.m_122780_((int)materialCount, (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialCount).forEach(i -> materials.set(i, (Object)StackedIngredient.fromNetwork(buffer)));
            ItemStack result = buffer.m_130267_();
            boolean notification = buffer.readBoolean();
            return new WorkbenchContructingRecipe((NonNullList<StackedIngredient>)materials, result, notification);
        }

        public void toNetwork(FriendlyByteBuf buffer, WorkbenchContructingRecipe recipe) {
            buffer.writeInt(recipe.materials.size());
            recipe.materials.forEach(ingredient -> ingredient.toNetwork(buffer));
            buffer.m_130055_(recipe.result);
            buffer.writeBoolean(recipe.notification);
        }
    }
}

