/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.network.play;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.TelevisionBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.client.FurnitureScreens;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.ToolAnimationRenderer;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.PostBoxScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.toast.ItemToast;
import com.mrcrayfish.furniture.refurbished.client.particle.ItemFlushParticle;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.graphics.PaddleBallGraphics;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.message.MessageClearMessage;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerState;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import com.mrcrayfish.furniture.refurbished.network.message.MessageNameMailbox;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.network.message.MessageShowDeliveryResult;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncFluid;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncLink;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTelevisionChannel;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ClientPlayHandler {
    public static void handleMessageSyncFluid(MessageSyncFluid message) {
        IFluidContainerBlock block;
        FluidContainer container;
        Minecraft mc = Minecraft.m_91087_();
        Level level = (Level)Objects.requireNonNull(mc.f_91073_);
        BlockEntity blockEntity = level.m_7702_(message.pos());
        if (blockEntity instanceof IFluidContainerBlock && (container = (block = (IFluidContainerBlock)blockEntity).getFluidContainer()) != null) {
            container.handleSync(level, message.fluid(), message.amount());
        }
    }

    public static void handleMessageFlipAnimation(MessageFlipAnimation message) {
        Minecraft mc = Minecraft.m_91087_();
        Level level = (Level)Objects.requireNonNull(mc.f_91073_);
        BlockEntity blockEntity = level.m_7702_(message.pos());
        if (blockEntity instanceof GrillBlockEntity) {
            GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
            grill.playFlipAnimation(message.index());
        } else {
            blockEntity = level.m_7702_(message.pos());
            if (blockEntity instanceof FryingPanBlockEntity) {
                FryingPanBlockEntity fryingPan = (FryingPanBlockEntity)blockEntity;
                fryingPan.playFlipAnimation(message.index());
            }
        }
    }

    public static void handleMessageClearMessage(MessageClearMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof PostBoxScreen) {
            PostBoxScreen postBox = (PostBoxScreen)screen;
            postBox.clearMessage();
        }
    }

    public static void handleMessageDoorbell(MessageDoorbellNotification message) {
        if (((Boolean)Config.CLIENT.doorbellNotification.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            MutableComponent title = Utils.translation("gui", "doorbell_rang", new Object[0]);
            MutableComponent description = Component.m_237113_((String)message.name());
            mc.m_91300_().m_94922_((Toast)new ItemToast((Component)title, (Component)description, new ItemStack((ItemLike)Items.f_42777_)));
        }
    }

    public static void handleMessageSyncLink(MessageSyncLink message) {
        LinkHandler.get().setLinkingNode(message.pos());
    }

    public static void handleMessageTelevisionChannel(MessageTelevisionChannel message) {
        Minecraft mc = Minecraft.m_91087_();
        Level level = (Level)Objects.requireNonNull(mc.f_91073_);
        BlockEntity blockEntity = level.m_7702_(message.pos());
        if (blockEntity instanceof TelevisionBlockEntity) {
            TelevisionBlockEntity television = (TelevisionBlockEntity)blockEntity;
            television.setChannelFromId(message.channel());
        }
    }

    public static void handleMessageComputerState(MessageComputerState message) {
        Minecraft mc = Minecraft.m_91087_();
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)abstractContainerMenu;
            ClientComputer computer = (ClientComputer)menu.getComputer();
            computer.launchProgram(message.id());
        }
    }

    @Nullable
    private static PaddleBallGraphics getPaddleGame() {
        ComputerMenu menu;
        ClientComputer computer;
        DisplayableProgram<?> displayableProgram;
        Minecraft mc = Minecraft.m_91087_();
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof ComputerMenu && (displayableProgram = (computer = (ClientComputer)(menu = (ComputerMenu)abstractContainerMenu).getComputer()).getDisplayable()) instanceof PaddleBallGraphics) {
            PaddleBallGraphics game = (PaddleBallGraphics)displayableProgram;
            return game;
        }
        return null;
    }

    public static void handleMessageTennisGamePaddlePosition(MessagePaddleBall.PaddlePosition message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.updatePaddles(message.playerPos(), message.opponentPos());
        }
    }

    public static void handleMessageTennisGameBallUpdate(MessagePaddleBall.BallUpdate message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.updateBall(message.ballX(), message.ballY(), message.velocityX(), message.velocityY());
        }
    }

    public static void handleMessagePaddleBallEvent(MessagePaddleBall.Event message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.handleEvent(message.data());
        }
    }

    public static void handleMessagePaddleBallOpponentName(MessagePaddleBall.OpponentName message) {
        PaddleBallGraphics game = ClientPlayHandler.getPaddleGame();
        if (game != null) {
            game.handleOpponentName(message.name());
        }
    }

    public static void handleMessageToolAnimation(MessageToolAnimation message) {
        switch (message.tool()) {
            case SPATULA: {
                ToolAnimationRenderer.get().playSpatulaAnimation(message.pos(), message.direction());
                break;
            }
            case KNIFE: {
                ToolAnimationRenderer.get().playKnifeAnimation(message.pos(), message.direction());
            }
        }
    }

    public static void handleMessageFlushItem(MessageFlushItem message) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(message.entityId())) instanceof ItemEntity) {
            ItemEntity entity2 = (ItemEntity)entity;
            EntityRenderDispatcher dispatcher = mc.m_91290_();
            RenderBuffers buffers = mc.m_91269_();
            Vec3 pos = Vec3.m_82512_((Vec3i)message.pos());
            mc.f_91061_.m_107344_((Particle)new ItemFlushParticle(dispatcher, buffers, mc.f_91073_, entity2, pos));
            mc.f_91073_.m_171642_(message.entityId(), Entity.RemovalReason.DISCARDED);
        }
    }

    public static void handleMessageWaterTapAnimation(MessageWaterTapAnimation message) {
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (blockEntity = mc.f_91073_.m_7702_(message.pos())) instanceof IWaterTap) {
            IWaterTap tap = (IWaterTap)blockEntity;
            tap.playWaterAnimation();
        }
    }

    public static void handleMessageWorkbenchItemCounts(MessageWorkbench.ItemCounts message) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (abstractContainerMenu = mc.f_91074_.f_36096_) instanceof WorkbenchMenu) {
            WorkbenchMenu menu = (WorkbenchMenu)abstractContainerMenu;
            menu.updateItemCounts(message.counts());
        }
    }

    public static void handleMessageNameMailbox(MessageNameMailbox message) {
        FurnitureScreens.openNameableScreen(message.pos(), (Component)Utils.translation("gui", "set_mailbox_name", new Object[0]), 32);
    }

    public static void handleMessageShowDeliveryResult(MessageShowDeliveryResult message) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof PostBoxScreen) {
            PostBoxScreen postBox = (PostBoxScreen)screen;
            postBox.showResponse(message.result());
        }
    }
}

